% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/grayplot.R
\name{grayplot}
\alias{grayplot}
\title{Plot with a gray background}
\usage{
grayplot(x, y, ..., type = "p", hlines, hlines.col = "white",
  hlines.lty = 1, hlines.lwd = 1, vlines, vlines.col = "white",
  vlines.lty = 1, vlines.lwd = 1, xat, yat, bgcolor = "gray80",
  v_over_h = FALSE)
}
\arguments{
\item{x}{Coordinates of points in the plot}

\item{y}{Corrdinates of points in the plot (optional)}

\item{...}{Optional graphics arguments}

\item{type}{Plot type (points, lines, etc.)}

\item{hlines}{Locations of horizontal grid lines; use \code{hlines=NA} to prevent horizontal grid lines}

\item{hlines.col}{Colors of horizontal grid lines}

\item{hlines.lty}{Line type of horizontal grid lines}

\item{hlines.lwd}{Line width of horizontal grid lines}

\item{vlines}{Locations of vertical grid lines; use \code{vlines=NA} to prevent vertical grid lines}

\item{vlines.col}{Colors of vertical grid lines}

\item{vlines.lty}{Line type of vertical grid lines}

\item{vlines.lwd}{Line width of vertical grid lines}

\item{xat}{Locations for x-axis labels; \code{xat=NA} indicates no labels}

\item{yat}{Locations for y-axis labels; \code{yat=NA} indicates no labels}

\item{bgcolor}{Background color}

\item{v_over_h}{If \code{TRUE}, place vertical grid lines on top of
the horizontal ones.}
}
\value{
None.
}
\description{
Like the plot function, but using a gray background just
  for the plot regin.
}
\details{
Calls \code{\link[graphics]{plot}} with \code{type="n"}, then
  \code{\link[graphics]{rect}} to get the background, and then
  \code{\link[graphics]{points}}.
  Additional arguments you can include: \code{mgp.x} and \code{mgp.y}
  (like \code{mgp}, for controlling parameters of axis labels, but
  separate for x- and y-axis).
}
\examples{
\dontshow{set.seed(97536917)}
x <- rnorm(100)
y <- x+rnorm(100, 0, 0.7)
grayplot(x, y, col="blue", pch=16)
at <- seq(-3, 3)
grayplot(x, y, col="blue", pch=16, hlines=at, vlines=at)
grayplot(x, col="violet", pch=16, bgcolor="gray90",
         hlines=seq(-4, 4, by=0.5), hlines.lwd=c(3,1),
         vlines=seq(0, 100, by=5), vlines.lwd=c(3,1,1,1))
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{par}},
  \code{\link[graphics]{rect}},
  \code{\link[graphics]{points}}
}
\keyword{graphics}

