% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/winsorize.R
\name{winsorize}
\alias{winsorize}
\title{Winsorize a vector}
\usage{
winsorize(x, q = 0.006)
}
\arguments{
\item{x}{Numeric vector}

\item{q}{Lower quantile to use}
}
\value{
A vector like the input \code{x}, but with extreme values moved in to
  the \code{q} and \code{1-q} quantiles.
}
\description{
For a numeric vector, move values below and above the q and 1-q
  quantiles to those quantiles.
}
\examples{
x <- sample(c(1:10, rep(NA, 10), 21:30))
winsorize(x, 0.2)
}
\keyword{utilities}

