% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-ac.R
\name{unstr}
\alias{unstr}
\title{Set up UNSTR correlation structures}
\usage{
unstr(time, gr)
}
\arguments{
\item{time}{An optional time variable specifying the time ordering
of the observations. By default, the existing order of the observations
in the data is used.}

\item{gr}{An optional grouping variable. If specified, the correlation
structure is assumed to apply only to observations within the same grouping
level.}
}
\value{
An object of class \code{'unstr_term'}, which is a list
  of arguments to be interpreted by the formula
  parsing functions of \pkg{brms}.
}
\description{
Set up an unstructured (UNSTR) correlation term in \pkg{brms}. The function does
not evaluate its arguments -- it exists purely to help set up a model with
UNSTR terms.
}
\examples{
\dontrun{
# add an unstructured correlation matrix for visits within the same patient
fit <- brm(count ~ Trt + unstr(visit, patient), data = epilepsy)
summary(fit)
}

}
\seealso{
\code{\link{autocor-terms}}
}
