% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{posterior_samples.brmsfit}
\alias{posterior_samples.brmsfit}
\alias{as.data.frame.brmsfit}
\alias{as.matrix.brmsfit}
\alias{as.array.brmsfit}
\alias{posterior_samples}
\alias{posterior.samples}
\alias{posterior_samples.brmsfit}
\alias{posterior.samples.brmsfit}
\title{Extract posterior samples}
\usage{
\method{posterior_samples}{brmsfit}(x, pars = NA, exact_match = FALSE,
  add_chain = FALSE, subset = NULL, as.matrix = FALSE, as.array = FALSE,
  ...)

\method{as.data.frame}{brmsfit}(x, row.names = NULL, optional = FALSE, ...)

\method{as.matrix}{brmsfit}(x, ...)

\method{as.array}{brmsfit}(x, ...)

posterior_samples(x, pars = NA, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{pars}{Names of parameters for which posterior samples 
should be returned, as given by a character vector or regular expressions.
By default, all posterior samples of all parameters are extracted.}

\item{exact_match}{Indicates whether parameter names 
should be matched exactly or treated as regular expression. 
Default is \code{FALSE}.}

\item{add_chain}{A flag indicating if the returned \code{data.frame} 
should contain two additional columns. The \code{chain} column 
indicates the chain in which each sample was generated, the \code{iter} 
column indicates the iteration number within each chain.}

\item{subset}{A numeric vector indicating the rows 
(i.e., posterior samples) to be returned. 
If \code{NULL} (the default), all  posterior samples are returned.}

\item{as.matrix}{Should the output be a \code{matrix} 
instead of a \code{data.frame}? Defaults to \code{FALSE}.}

\item{as.array}{Should the output be an \code{array} 
instead of a \code{data.frame}? Defaults to \code{FALSE}.}

\item{...}{For \code{as.data.frame}, \code{as.matrix}, and \code{as.array}:
Further arguments to be passed to \code{posterior_samples}.}

\item{row.names, optional}{See \code{\link[base:as.data.frame]{as.data.frame}}.}
}
\value{
A data frame (matrix or array) containing the posterior samples, 
  with one column per parameter. In case an array is returned,
  it contains one additional dimension for the chains.
}
\description{
Extract posterior samples of specified parameters
}
\details{
Currently there are methods for \code{brmsfit} objects.
  \code{as.data.frame.brmsfit}, \code{as.matrix.brmsfit}, and
  \code{as.array.brmsfit} are basically aliases of 
  \code{posterior_samples.brmsfit} and differ from
  each other only in type of the returned object.
}
\examples{
\dontrun{
fit <- brm(rating ~ treat + period + carry + (1|subject), 
           data = inhaler, family = "cumulative")

# extract posterior samples of population-level effects 
samples1 <- posterior_samples(fit, "^b")
head(samples1)

# extract posterior samples of group-level standard deviations
samples2 <- posterior_samples(fit, "^sd_")
head(samples2)
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
