% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{cor_ar}
\alias{cor_ar}
\alias{cor.ar}
\title{AR(p) correlation structure}
\usage{
cor_ar(formula = ~1, p = 1, cov = FALSE)
}
\arguments{
\item{formula}{A one sided formula of the form \code{~ t}, or \code{~ t | g}, 
specifying a time covariate \code{t} and, optionally, 
a grouping factor \code{g}. 
A covariate for this correlation structure must be integer valued. 
When a grouping factor is present in \code{formula}, the correlation structure 
is assumed to apply only to observations within the same grouping level; 
observations with different grouping levels are assumed to be uncorrelated. 
Defaults to \code{~ 1}, which corresponds to using the order of the observations 
in the data as a covariate, and no groups.}

\item{p}{A non-negative integer specifying the autoregressive (AR) order of the ARMA structure. 
Default is 0.}

\item{cov}{A flag indicating whether ARMA effects should be estimated by means
of residual covariance matrices
(currently only possible for stationary ARMA effects of order 1). 
If \code{FALSE} (the default) a regression formulation
is used that is considerably faster and allows for ARMA effects 
of order higher than 1 but cannot handle user defined standard errors.}
}
\value{
An object of class \code{cor_arma} containing solely autoregression terms.
}
\description{
This function is a constructor for the \code{cor_arma} class, 
allowing for autoregression terms only.
}
\details{
AR refers to autoregressive effects of residuals, which
  is what is typcially understood as autoregressive effects.
  However, one may also model autoregressive effects of the response
  variable, which is called ARR in \pkg{brms}.
}
\examples{
cor_ar(~visit|patient, p = 2)

}
\seealso{
\code{\link{cor_arma}}
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
