% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{add_ic.brmsfit}
\alias{add_ic.brmsfit}
\alias{add_ic}
\title{Add information criteria to fitted model objects}
\usage{
\method{add_ic}{brmsfit}(x, ic = "loo", ...)

add_ic(x, ...)
}
\arguments{
\item{x}{An \R object typically of class \code{brmsfit}.}

\item{ic}{Names of the information criteria to compute.
Currently supported are \code{"loo"} and \code{"waic"}.}

\item{...}{Further arguments passed to 
\code{\link[brms:LOO]{LOO}} or \code{\link[brms:WAIC]{WAIC}}.}
}
\value{
An object of the same class as \code{x}, but
  with information criteria added for later usage.
}
\description{
Add information criteria to fitted model objects
}
\examples{
\dontrun{
fit <- brm(count ~ Trt, epilepsy, poisson())
# add both LOO and WAIC at once
fit <- add_ic(fit, ic = c("loo", "waic"))
print(fit$loo)
print(fit$waic)
}

}
