  /* von Mises log-PDF of a single response
   * for kappa > 100 the normal approximation is used
   * for reasons of numerial stability
   * Args: 
   *   y: the response vector between -pi and pi 
   *   mu: location parameter vector
   *   kappa: precision parameter
   * Returns:  
   *   a scalar to be added to the log posterior 
   */ 
   real von_mises_real_lpdf(real y, real mu, real kappa) {
     if (kappa < 100) {
       return von_mises_lpdf(y | mu, kappa);
     } else {
       return normal_lpdf(y | mu, sqrt(1 / kappa));
     }
   }
  /* von Mises log-PDF of a response vector
   * for kappa > 100 the normal approximation is used
   * for reasons of numerial stability
   * Args: 
   *   y: the response vector between -pi and pi 
   *   mu: location parameter vector
   *   kappa: precision parameter
   * Returns:  
   *   a scalar to be added to the log posterior 
   */ 
   real von_mises_vector_lpdf(vector y, vector mu, real kappa) {
     if (kappa < 100) {
       return von_mises_lpdf(y | mu, kappa);
     } else {
       return normal_lpdf(y | mu, sqrt(1 / kappa));
     }
   }
