% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-helpers.R
\name{compare_ic}
\alias{compare_ic}
\title{Compare Information Criteria of Different Models}
\usage{
compare_ic(..., x = NULL, ic = c("loo", "waic"))
}
\arguments{
\item{...}{At least two objects returned by 
\code{\link[brms:WAIC]{WAIC}} or \code{\link[brms:LOO]{LOO}}.
Alternatively, \code{brmsfit} objects with information 
criteria precomputed via \code{\link[brms:add_ic]{add_ic}}
may be passed, as well.}

\item{x}{A \code{list} containing the same types of objects as
can be passed via \code{...}.}

\item{ic}{The name of the information criterion to be extracted 
from \code{brmsfit} objects. Ignored if information 
criterion objects are only passed directly.}
}
\value{
An object of class \code{iclist}.
}
\description{
Compare information criteria of different models fitted
with \code{\link[brms:WAIC]{WAIC}} or \code{\link[brms:LOO]{LOO}}.
}
\details{
For more details see \code{\link[loo:compare]{compare}}.
}
\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler, family = "gaussian")
w1 <- WAIC(fit1)

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler, family = "gaussian")
w2 <- WAIC(fit2)

# compare both models
compare_ic(w1, w2)
}

}
\seealso{
\code{\link[brms:WAIC]{WAIC}}, 
  \code{\link[brms:LOO]{LOO}},
  \code{\link[brms:add_ic]{add_ic}},
  \code{\link[loo:compare]{compare}}
}
