% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/correlations.R
\name{cor_arma}
\alias{cor.arma}
\alias{cor_arma}
\title{ARMA(p,q) correlation structure}
\usage{
cor_arma(formula = ~1, p = 0, q = 0)
}
\arguments{
\item{formula}{A one sided formula of the form ~ t, or ~ t | g, specifying a time covariate t and, optionally, a grouping factor g.
A covariate for this correlation structure must be integer valued. When a grouping factor is present in \code{formula}, the correlation structure
is assumed to apply only to observations within the same grouping level; observations with different grouping levels are assumed to be uncorrelated.
Defaults to ~ 1, which corresponds to using the order of the observations in the data as a covariate, and no groups.}

\item{p}{A non-negative integer specifying the autoregressive order of the ARMA structure. Default is 0.}

\item{q}{A non-negative integer specifying the moving average order of the ARMA structure. Default is 0.}
}
\value{
An object of class \code{cor_arma}, representing an autoregression-moving average correlation structure.
}
\description{
This functions is a constructor for the \code{cor_arma} class, representing an autoregression-moving average correlation structure of order (p, q).
}
\examples{
cor_arma(~visit|patient, p = 2, q = 2)
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

