% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brk_toxFunction.R
\name{brk_toxFun}
\alias{brk_toxFun}
\alias{brk_toxFun_damage1}
\alias{brk_toxFun_survival1}
\alias{brk_toxFun_survival2}
\alias{brk_survIT}
\alias{brk_survSD}
\title{Functions for Toxicokinetic-Toxidynamic (TKTD) models}
\usage{
brk_toxFun_damage1(exposure, kin, kout)

brk_toxFun_survival1(damage, alpha1, alpha2, alpha3)

brk_toxFun_survival2(damage, LC50, slope)

brk_survIT(time, Cw, listParameters)

brk_survSD(time, Cw, listParameters)
}
\arguments{
\item{exposure}{exposure level of individual}

\item{kin}{parameter describing the intake rate of the element}

\item{kout}{parameter describing the excretion rate of the element}

\item{damage}{damage level on which the survival model is going to be applied}

\item{alpha1}{parameter describing the natural background death mortality rate}

\item{alpha2}{parameter describing the killing rate of the element on individual}

\item{alpha3}{exponential parameter describing the killing rate of the element on individual}

\item{LC50}{parameter describing the lethal concentration for 50\% of the population}

\item{slope}{parameter describing the slope of the curve}

\item{time}{vector of time of the exposure profile}

\item{Cw}{vector of concentration of the exposure profile}

\item{listParameters}{A list of parameter for the SD model}
}
\description{
Functions for Toxicokinetic-Toxidynamic (TKTD) models

ODE solver applied to IT-GUTS model

ODE solver applied to SD-GUTS model
}
