% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individuals-Methods.R
\name{loadIndividuals}
\alias{loadIndividuals}
\title{Wrapper function loadIndividuals}
\usage{
loadIndividuals(objectL, sp, data, mintime, maxtime)
}
\arguments{
\item{objectL}{a \link{Landscape} object}

\item{sp}{a SpatialPoints object (individuals coordinates)}

\item{data}{a data.frame containing individuals attributes. Rows numbers as individuals ID, columns names as dob (date of birth) | life_duration | toxic_threshold}

\item{mintime}{Start simulation time}

\item{maxtime}{End simulation time}
}
\value{
an \code{\link{Individuals}} object
}
\description{
Wrapper function to create an \link{Individuals} object using SpatialPoints and data.frame .

The SpatialPoints object and the data.frame have to contain the same number of coordinates and rows.
}
\examples{
 
library(sp)
data(maize_65)
# simulate 2 individuals coordinates (SpatialPoints object) and data:
coordinates <- SpatialPoints(matrix(c(468232.1,6259993,464848.8,6260483),ncol=2,byrow=TRUE),
proj4string=CRS("+init=epsg:2154"))
df <- data.frame("dob"=c(1,8),"life_duration"=c(20,20),
           "toxic_threshold"=c(15,15),row.names = c(1,2))
# create an Indiviudals object from previous data
ind <- loadIndividuals(objectL=maize.landscape,sp=coordinates,data=df,mintime=1,maxtime=61)
plot(maize.landscape,ind)
}
