% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape-Methods.R
\name{saveIntoFile}
\alias{saveIntoFile}
\title{Save Particles Dispersion 3D Array to tiff file}
\usage{
saveIntoFile(objectL, objectT, filename = "ParticlesDispersion.tif",
  format = "GTiff", overwrite = T)
}
\arguments{
\item{objectL}{a \link{Landscape} object}

\item{objectT}{a 3D array particles dispersion indexed by time (output from \link{toxicIntensity})}

\item{filename}{output file name (default "ParticlesDispersion.tif")}

\item{format}{output format (default=GTiff)}

\item{overwrite}{if TRUE overwrite file (default TRUE)}
}
\value{
a RasterStack object
}
\description{
Save into tiff file particles dispersion 3D array from toxicIntensity.
The output is a RasterStack with a layer per time unit with projection set to CRS="+proj=longlat +datum=WGS84"
}
\examples{
\dontrun{
data(maize_65)
ti<-toxicIntensity(maize.landscape,maize.emitted_pollen)
saveIntoFile(maize.landscape,ti,filename="ParticlesDispersion.tiff",format="GTiff",overwrite=T)
}
}

