% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{s3_storage_info}
\alias{s3_storage_info}
\title{S3 Storage Info}
\usage{
s3_storage_info(
  destination,
  region = NULL,
  endpoint = NULL,
  enable_encryption = FALSE,
  encryption_type = c("sse-s3", "sse-kms"),
  kms_key = NULL,
  canned_acl = NULL
)
}
\arguments{
\item{destination}{S3 destination. For example: \verb{s3://my-bucket/some-prefix}.
You must configure the cluster with an instance profile and the instance
profile must have write access to the destination. \strong{You cannot use AWS
keys}.}

\item{region}{S3 region. For example: \code{us-west-2}. Either region or endpoint
must be set. If both are set, endpoint is used.}

\item{endpoint}{S3 endpoint. For example:
\verb{https://s3-us-west-2.amazonaws.com}. Either region or endpoint must be set.
If both are set, endpoint is used.}

\item{enable_encryption}{Boolean (Default: \code{FALSE}). If \code{TRUE} Enable server
side encryption.}

\item{encryption_type}{Encryption type, it could be \code{sse-s3} or \code{sse-kms}. It
is used only when encryption is enabled and the default type is \code{sse-s3}.}

\item{kms_key}{KMS key used if encryption is enabled and encryption type is
set to \code{sse-kms}.}

\item{canned_acl}{Set canned access control list. For example:
\code{bucket-owner-full-control}. If \code{canned_acl} is set, the cluster instance
profile must have \code{s3:PutObjectAcl} permission on the destination bucket and
prefix. The full list of possible canned ACLs can be found in
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl}{docs}.
By default only the object owner gets full control. If you are using cross
account role for writing data, you may want to set
\code{bucket-owner-full-control} to make bucket owner able to read the logs.}
}
\description{
S3 Storage Info
}
\seealso{
\code{\link[=cluster_log_conf]{cluster_log_conf()}}, \code{\link[=init_script_info]{init_script_info()}}

Other Cluster Log Configuration Objects: 
\code{\link{cluster_log_conf}()},
\code{\link{dbfs_storage_info}()}

Other Init Script Info Objects: 
\code{\link{dbfs_storage_info}()},
\code{\link{file_storage_info}()}
}
\concept{Cluster Log Configuration Objects}
\concept{Init Script Info Objects}
