% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-tables.R
\name{db_uc_tables_get}
\alias{db_uc_tables_get}
\title{Get Table (Unity Catalog)}
\usage{
db_uc_tables_get(
  catalog,
  schema,
  table,
  omit_columns = TRUE,
  omit_properties = TRUE,
  omit_username = TRUE,
  include_browse = TRUE,
  include_delta_metadata = TRUE,
  include_manifest_capabilities = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{catalog}{Parent catalog of table.}

\item{schema}{Parent schema of table.}

\item{table}{Table name.}

\item{omit_columns}{Whether to omit the columns of the table from the
response or not.}

\item{omit_properties}{Whether to omit the properties of the table from the
response or not.}

\item{omit_username}{Whether to omit the username of the table (e.g. owner,
updated_by, created_by) from the response or not.}

\item{include_browse}{Whether to include tables in the response for which the
principal can only access selective metadata for.}

\item{include_delta_metadata}{Whether delta metadata should be included in
the response.}

\item{include_manifest_capabilities}{Whether to include a manifest containing
capabilities the table has.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
Get Table (Unity Catalog)
}
\seealso{
Other Unity Catalog Table Management: 
\code{\link{db_uc_tables_delete}()},
\code{\link{db_uc_tables_exists}()},
\code{\link{db_uc_tables_list}()},
\code{\link{db_uc_tables_summaries}()}
}
\concept{Unity Catalog Table Management}
