% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-connector.R
\name{DatabricksSqlClient}
\alias{DatabricksSqlClient}
\title{Databricks SQL Connector}
\description{
Wraps the \href{https://github.com/databricks/databricks-sql-python}{\code{databricks-sql-connector}}
using \href{https://rstudio.github.io/reticulate/}{reticulate}.

\href{https://docs.databricks.com/en/dev-tools/python-sql-connector.html#api-reference}{API reference on Databricks docs}
}
\examples{

## ------------------------------------------------
## Method `DatabricksSqlClient$columns`
## ------------------------------------------------

\dontrun{
  client$columns(catalog_name = "defa\%")
  client$columns(catalog_name = "default", table_name = "gold_\%")
}

## ------------------------------------------------
## Method `DatabricksSqlClient$catalogs`
## ------------------------------------------------

\dontrun{
  client$catalogs()
}

## ------------------------------------------------
## Method `DatabricksSqlClient$schemas`
## ------------------------------------------------

\dontrun{
  client$schemas(catalog_name = "main")
}

## ------------------------------------------------
## Method `DatabricksSqlClient$execute`
## ------------------------------------------------

\dontrun{
 client$execute("select 1")
 client$execute("select * from x.y.z limit 100")
 client$execute(
   operation = "select * from x.y.z where a < \%(threshold)s limit 1000",
   parameters = list(threshold = 100)
 )
}

## ------------------------------------------------
## Method `DatabricksSqlClient$execute_many`
## ------------------------------------------------

\dontrun{
 client$execute_many(
   operation = "select * from x.y.z where a < \%(threshold)s limit 1000",
   seq_of_parameters = list(
     list(threshold = 100),
     list(threshold = 200),
     list(threshold = 300)
   )
 )
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-db_sql_client-new}{\code{DatabricksSqlClient$new()}}
\item \href{#method-db_sql_client-columns}{\code{DatabricksSqlClient$columns()}}
\item \href{#method-db_sql_client-catalogs}{\code{DatabricksSqlClient$catalogs()}}
\item \href{#method-db_sql_client-schemas}{\code{DatabricksSqlClient$schemas()}}
\item \href{#method-db_sql_client-tables}{\code{DatabricksSqlClient$tables()}}
\item \href{#method-db_sql_client-execute}{\code{DatabricksSqlClient$execute()}}
\item \href{#method-db_sql_client-execute_many}{\code{DatabricksSqlClient$execute_many()}}
\item \href{#method-db_sql_client-clone}{\code{DatabricksSqlClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-new"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.

Note that this object is typically constructed via \code{\link[=db_sql_client]{db_sql_client()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$new(
  host,
  token,
  http_path,
  catalog,
  schema,
  use_cloud_fetch,
  session_configuration,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{(\code{character(1)})\cr
See \code{\link[=db_sql_client]{db_sql_client()}}.}

\item{\code{token}}{(\code{character(1)})\cr
See \code{\link[=db_sql_client]{db_sql_client()}}.}

\item{\code{http_path}}{(\code{character(1)})\cr
See \code{\link[=db_sql_client]{db_sql_client()}}.}

\item{\code{catalog}}{(\code{character(1)})\cr
See \code{\link[=db_sql_client]{db_sql_client()}}.}

\item{\code{schema}}{(\code{character(1)})\cr
See \code{\link[=db_sql_client]{db_sql_client()}}.}

\item{\code{use_cloud_fetch}}{(\code{logical(1)})\cr
See \code{\link[=db_sql_client]{db_sql_client()}}.}

\item{\code{session_configuration}}{(\code{list(...)})\cr
See \code{\link[=db_sql_client]{db_sql_client()}}.}

\item{\code{...}}{Parameters passed to \href{https://docs.databricks.com/en/dev-tools/python-sql-connector.html#methods}{connection method}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{DatabricksSqlClient}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-columns"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-columns}{}}}
\subsection{Method \code{columns()}}{
Execute a metadata query about the columns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$columns(
  catalog_name = NULL,
  schema_name = NULL,
  table_name = NULL,
  column_name = NULL,
  as_tibble = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{catalog_name}}{(\code{character(1)})\cr
A catalog name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{schema_name}}{(\code{character(1)})\cr
A schema name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{table_name}}{(\code{character(1)})\cr
A table name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{column_name}}{(\code{character(1)})\cr
A column name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{as_tibble}}{(\code{logical(1)})\cr
If \code{TRUE} (default) will return \link[tibble:tibble]{tibble::tibble}, otherwise returns
\link[arrow:Table-class]{arrow::Table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[tibble:tibble]{tibble::tibble} or \link[arrow:Table-class]{arrow::Table}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  client$columns(catalog_name = "defa\%")
  client$columns(catalog_name = "default", table_name = "gold_\%")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-catalogs"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-catalogs}{}}}
\subsection{Method \code{catalogs()}}{
Execute a metadata query about the catalogs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$catalogs(as_tibble = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{as_tibble}}{(\code{logical(1)})\cr
If \code{TRUE} (default) will return \link[tibble:tibble]{tibble::tibble}, otherwise returns
\link[arrow:Table-class]{arrow::Table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[tibble:tibble]{tibble::tibble} or \link[arrow:Table-class]{arrow::Table}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  client$catalogs()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-schemas"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-schemas}{}}}
\subsection{Method \code{schemas()}}{
Execute a metadata query about the schemas.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$schemas(
  catalog_name = NULL,
  schema_name = NULL,
  as_tibble = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{catalog_name}}{(\code{character(1)})\cr
A catalog name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{schema_name}}{(\code{character(1)})\cr
A schema name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{as_tibble}}{(\code{logical(1)})\cr
If \code{TRUE} (default) will return \link[tibble:tibble]{tibble::tibble}, otherwise returns
\link[arrow:Table-class]{arrow::Table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[tibble:tibble]{tibble::tibble} or \link[arrow:Table-class]{arrow::Table}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  client$schemas(catalog_name = "main")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-tables"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-tables}{}}}
\subsection{Method \code{tables()}}{
Execute a metadata query about tables and views
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$tables(
  catalog_name = NULL,
  schema_name = NULL,
  table_name = NULL,
  table_types = NULL,
  as_tibble = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{catalog_name}}{(\code{character(1)})\cr
A catalog name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{schema_name}}{(\code{character(1)})\cr
A schema name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{table_name}}{(\code{character(1)})\cr
A table name to retrieve information about.
The \verb{\%} character is interpreted as a wildcard.}

\item{\code{table_types}}{(\code{character()})\cr
A list of table types to match, for example \code{"TABLE"} or \code{"VIEW"}.}

\item{\code{as_tibble}}{(\code{logical(1)})\cr
If \code{TRUE} (default) will return \link[tibble:tibble]{tibble::tibble}, otherwise returns
\link[arrow:Table-class]{arrow::Table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[tibble:tibble]{tibble::tibble} or \link[arrow:Table-class]{arrow::Table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-execute"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-execute}{}}}
\subsection{Method \code{execute()}}{
Prepares and then runs a database query or command.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$execute(operation, parameters = NULL, as_tibble = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operation}}{(\code{character(1)})\cr
The query or command to prepare and then run.}

\item{\code{parameters}}{(\code{list()})\cr
Optional. A sequence of parameters to use with the operation parameter.}

\item{\code{as_tibble}}{(\code{logical(1)})\cr
If \code{TRUE} (default) will return \link[tibble:tibble]{tibble::tibble}, otherwise returns
\link[arrow:Table-class]{arrow::Table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[tibble:tibble]{tibble::tibble} or \link[arrow:Table-class]{arrow::Table}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 client$execute("select 1")
 client$execute("select * from x.y.z limit 100")
 client$execute(
   operation = "select * from x.y.z where a < \%(threshold)s limit 1000",
   parameters = list(threshold = 100)
 )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-execute_many"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-execute_many}{}}}
\subsection{Method \code{execute_many()}}{
Prepares and then runs a database query or command using all parameter
sequences in the seq_of_parameters argument. Only the final result set
is retained.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$execute_many(
  operation,
  seq_of_parameters = NULL,
  as_tibble = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{operation}}{(\code{character(1)})\cr
The query or command to prepare and then run.}

\item{\code{seq_of_parameters}}{(\code{list(list())})\cr
A sequence of many sets of parameter values to use with the operation
parameter.}

\item{\code{as_tibble}}{(\code{logical(1)})\cr
If \code{TRUE} (default) will return \link[tibble:tibble]{tibble::tibble}, otherwise returns
\link[arrow:Table-class]{arrow::Table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[tibble:tibble]{tibble::tibble} or \link[arrow:Table-class]{arrow::Table}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 client$execute_many(
   operation = "select * from x.y.z where a < \%(threshold)s limit 1000",
   seq_of_parameters = list(
     list(threshold = 100),
     list(threshold = 200),
     list(threshold = 300)
   )
 )
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-db_sql_client-clone"></a>}}
\if{latex}{\out{\hypertarget{method-db_sql_client-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatabricksSqlClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
