% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-instructions.R
\name{build_instructions}
\alias{build_instructions}
\title{Create instruction manual for a 2D mosaic or 3D model}
\usage{
build_instructions(brickr_obj, num_steps = 6)
}
\arguments{
\item{brickr_obj}{brickr mosaic or 3D model object.}

\item{num_steps}{Number of discrete steps in instruction manual, for mosaics only.}
}
\value{
A single plot object of steps to build brickr model or mosaic.
}
\description{
Render faceted plot of instructions for 2D mosacis or 3D model objects. For mosaics, can specify the number of steps.
}
\details{
Instructions for 2D mosaics are split into sections beginning at the bottom of the image.
This makes it easier to follow each row when building an actual brick mosaic.

3D model instructions are displayed one Level (z value) at a time.
The current model level is clearly displayed, while the previous level is shows as transparent.
}
\examples{
# Import a jpeg or png
 demo_file <- system.file("extdata", "demo_img.jpg", 
                          package = "brickr", mustWork = TRUE)
 demo_image <- jpeg::readJPEG(demo_file)
 
 #Create a mosaic oject 
 \donttest{
 mosaic <- demo_image \%>\% 
   image_to_mosaic(img_size = 24)
 }
 
 #Rather than drawing the mosaic, use build_instructions() to draw instructions
 \donttest{
  mosaic \%>\% 
   build_instructions()
 }

#Change the number of steps for more detail
\donttest{
  mosaic \%>\% 
   build_instructions(num_steps = 9)
 }

}
\seealso{
Other Resources: 
\code{\link{build_colors}()},
\code{\link{build_pieces_table}()},
\code{\link{build_pieces}()}
}
\concept{Resources}
