% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect-bricks.R
\name{collect_bricks}
\alias{collect_bricks}
\title{Consolidate 1x1 bricks into larger ones of the same color}
\usage{
collect_bricks(image_list, use_bricks = NULL, default_piece_type = "b")
}
\arguments{
\item{image_list}{List output containing an element \code{Img_lego}.}

\item{use_bricks}{Array of brick sizes to use in mosaic. Defaults to \code{c('4x2', '2x2', '3x1', '2x1', '1x1')}`.}

\item{default_piece_type}{Piece type to use in absence of piece_type column.}
}
\value{
A list with element \code{Img_bricks} containing a data frame of the x- & y-coordinates, R, G, B channels, and brick ID. Other helper elements.
}
\description{
Internal function for collecting single bricks into large ones. Used in both mosaics and 3D models.
Automatically generate missing piece_type or mid_level.
}
\keyword{internal}
