% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_mean.R
\name{segment.mean}
\alias{segment.mean}
\title{Multiple change-point detection in the mean of a vector}
\usage{
segment.mean(x, attribute = "speed", M = 1000,
  sigma = stats::mad(diff(x)/sqrt(2)), th.const = 1, p = 0.01,
  minseglen = 1, bal = 1/20, num.zero = 10^(-5))
}
\arguments{
\item{x}{A vector containing the data in which you wish to find change-points.}

\item{attribute}{As described in the Details section of this help file.}

\item{M}{The same as the corresponding parameter in \code{\link{hybrid.cpt}}.}

\item{sigma}{The same as the corresponding parameter in \code{\link{tguh.cpt}} and \code{\link{hybrid.cpt}}.}

\item{th.const}{The same as the corresponding parameter in \code{\link{tguh.cpt}} and \code{\link{hybrid.cpt}}.}

\item{p}{The same as the corresponding parameter in \code{\link{tguh.cpt}} and \code{\link{hybrid.cpt}}.}

\item{minseglen}{The same as the corresponding parameter in \code{\link{tguh.cpt}} and \code{\link{hybrid.cpt}}.}

\item{bal}{The same as the corresponding parameter in \code{\link{tguh.cpt}} and \code{\link{hybrid.cpt}}.}

\item{num.zero}{The same as the corresponding parameter in \code{\link{tguh.cpt}} and \code{\link{hybrid.cpt}}.}
}
\value{
A list with the following components:
\item{est}{The estimated piecewise-constant mean of \code{x}.}
\item{no.of.cpt}{The estimated number of change-points in the piecewise-constant mean of \code{x}.}
\item{cpt}{The estimated locations of change-points in the piecewise-contant mean of \code{x} (these
are the final indices \emph{before} the location of each change-point).}
}
\description{
This function estimates the number and locations of change-points in the 
piecewise-constant mean of the noisy input vector, using a method that puts more emphasis
either on "speed" (i.e. is faster but possibly less accurate) or on "accuracy" (i.e. is
possibly more accurate but slower).
It also estimates the constant means between each pair of neighbouring change-points.
It works best when the noise in the input vector is independent and identically distributed Gaussian.
}
\details{
In the current version of the package, \code{attribute="speed"} triggers the function
\code{\link{tguh.cpt}} and \code{attribute="accuracy"} triggers the function
\code{\link{hybrid.cpt}}. \strong{Warning:} this can change in future versions of the
package. Note that \code{\link{tguh.cpt}} and \code{\link{hybrid.cpt}} return the same number
of change-points and the only difference lies in their estimated locations.
}
\examples{
stairs <- rep(1:50, each=10)
stairs.noisy <- stairs + rnorm(500)/5
stairs.cleaned <- segment.mean(stairs.noisy)
ts.plot(stairs.cleaned$est)
stairs.cleaned$no.of.cpt
stairs.cleaned$cpt
}
\seealso{
\code{\link{tguh.cpt}}, \code{\link{hybrid.cpt}}, \code{\link{wbs.cpt}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
