% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnumrange.R
\name{bnumrange}
\alias{bnumrange}
\title{Pre-filters a data file using column numerical range before loading it in memory}
\usage{
bnumrange(
  file = NULL,
  range_min = NULL,
  range_max = NULL,
  numrange_columns = NULL,
  ...
)
}
\arguments{
\item{file}{String. Name or full path to a file compatible with data.table::fread()}

\item{range_min}{Vector of numeric. One or several minimal values used to filter (inclusively, as in superior OR EQUAL to that value) the data from the input file. Each element of the vector should correspond to the numrange_column to be filtered.}

\item{range_max}{Vector of numeric. One or several maximal values used to filter (inclusively, as in inferior OR EQUAL to that value) the data from the input file. Each element of the vector should correspond to the numrange_column to be filtered.}

\item{numrange_columns}{Vector of strings or numeric. The columns to be filtered should be indicated through their names or their index number. Each element of the vector should correspond to the range_min and range_man values with which it will be filtered.}

\item{...}{Arguments that must be passed to data.table::fread() like 'sep' and 'dec'.}
}
\value{
A dataframe
}
\description{
Simple wrapper for data.table::fread() allowing to filter data by numerical value
from a file with the Unix 'awk' command. This method is useful if you want to
load a file too large for your available memory (and encounter
the 'cannot allocate vector of size' error #' for example).
}
\section{Warning}{
 The value comparisons are inclusive, meaning inferior/superior OR EQUAL
}

\examples{
file <- system.file('extdata', 'test.csv', package = 'bread')

## Filtering with only min value


## Filtering on 2 columns
bnumrange(file = file, range_min = c(2006, 1500), range_max = c(2010, 1990),
      numrange_columns = c(1,3))
bnumrange(file = file, range_min = c(2000, 1500), range_max = c(2005, 1990),
      numrange_columns = c('YEAR', 'PRICE'), sep = ';')

}
\keyword{allocate}
\keyword{awk}
\keyword{big}
\keyword{file}
\keyword{filter}
\keyword{size}
\keyword{vector}
