% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mip.sven.R
\name{mip.sven}
\alias{mip.sven}
\title{Compute marginal inclusion probabilities from a fitted "sven" object.}
\usage{
mip.sven(object, threshold = 0)
}
\arguments{
\item{object}{A fitted "sven" object}

\item{threshold}{marginal inclusion probabilities above this threshold are stored. Default 0.}
}
\value{
The object returned is a data frame if the \code{sven} was run with a single matrix, 
or a list of two data frames if \code{sven} was run with a list of two matrices.
The first column are the variable names (or numbers if column names of were absent). 
Only the nonzero marginal inclusion probabilities are stored.
}
\description{
This function computes the marginal inclusion probabilities of all variables from
a fitted "sven" object.
}
\examples{
\donttest{
n <- 50; p <- 100; nonzero <- 3
trueidx <- 1:3
truebeta <- c(4,5,6)
X <- matrix(rnorm(n*p), n, p) # n x p covariate matrix
y <- 0.5 + X[,trueidx] \%*\% truebeta + rnorm(n)
res <- sven(X=X, y=y)
res$model.map # the MAP model
mip.sven(res)

Z <- matrix(rnorm(n*p), n, p) # another covariate matrix
y2 = 0.5 + X[,trueidx] \%*\% truebeta  + Z[,1:2] \%*\% c(-2,-2) + rnorm(n)
res2 <- sven(X=list(X,Z), y=y2)
mip.sven(res2) # two data frames, one for X and another for Z
}
}
\author{
Somak Dutta\cr Maintainer:
Somak Dutta <somakd@iastate.edu>
}
