% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graphs.R
\name{make_empty_brainGraph}
\alias{make_empty_brainGraph}
\title{Create an empty graph with attributes for brainGraph}
\usage{
make_empty_brainGraph(atlas, ...)
}
\arguments{
\item{atlas}{Character string of the atlas to create a graph from}

\item{...}{Other arguments passed to \code{\link{make_brainGraph}}}
}
\value{
An empty \code{brainGraph} graph object
}
\description{
This function creates an empty undirected graph with vertex count equal to
the atlas specified, and includes some graph-, vertex-, and
edge-level attributes that are important for \code{brainGraph} functions.
Basically a wrapper for \code{\link[igraph]{make_empty_graph}}.
}
\seealso{
\code{\link[igraph]{make_empty_graph}}

Other Graph creation functions: \code{\link{make_brainGraph}},
  \code{\link{make_ego_brainGraph}},
  \code{\link{make_glm_brainGraph}},
  \code{\link{make_mediate_brainGraph}},
  \code{\link{make_nbs_brainGraph}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Graph creation functions}
