% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{xfm.weights}
\alias{xfm.weights}
\title{Transform edge weights}
\usage{
xfm.weights(g, xfm.type = c("1/w", "-log(w)", "1-w"), invert = FALSE)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{xfm.type}{Character string specifying how to transform the weights
(default: \code{1/w})}

\item{invert}{Logical indicating whether or not to invert the transformation
(default: \code{FALSE})}
}
\value{
An \code{igraph} graph object with transformed edge weights and a
  graph attribute, \code{xfm.type}, of the type of transform
}
\description{
For distance-based measures, it is important to transform the edge weights so
that the \emph{strongest} connections are re-mapped to having the
\emph{lowest} weights. Then you may calculate e.g., the \emph{shortest path
length} which will include the strongest connections.
}
\details{
There are 3 options for the type of transform to apply:
\enumerate{
  \item \code{1/w}: calculate the inverse
  \item \code{-log(w)}: calculate the negative (natural) logarithm
  \item \code{1-w}: subtract each weight from 1
}

To transform the weights back to original values, specify \code{invert=TRUE}.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
