% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graphs.R
\name{make_nbs_brainGraph}
\alias{make_nbs_brainGraph}
\title{Create a graph with NBS-specific attributes}
\usage{
make_nbs_brainGraph(res.nbs, atlas, ...)
}
\arguments{
\item{res.nbs}{List that is output by \code{\link{NBS}}}

\item{atlas}{Character string specifying the brain atlas to use}

\item{...}{Other arguments passed to \code{\link{make_brainGraph}}}
}
\value{
A list of \code{igraph} graph objects (length equal to the number of
  contrasts) with additional attributes:
  \item{Graph}{\emph{name} (contrast name)}
  \item{Vertex}{\emph{comp} (integer vector indicating connected component
    membership), \emph{p.nbs} (P-value for each component)}
  \item{Edge}{\emph{stat} (the test statistic for each connection), \emph{p}
    (the P-value)}
}
\description{
Create a graph with NBS-specific attributes
}
\seealso{
Other Graph creation functions: \code{\link{make_brainGraph}},
  \code{\link{make_ego_brainGraph}},
  \code{\link{make_empty_brainGraph}},
  \code{\link{make_glm_brainGraph}},
  \code{\link{make_mediate_brainGraph}}
}
\concept{Graph creation functions}
