% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_core.R
\name{s_core}
\alias{s_core}
\title{Calculate the s-core of a network}
\usage{
s_core(g, W = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{W}{Numeric matrix of edge weights (default: \code{NULL})}
}
\value{
Integer vector of the vertices' \emph{s-core} membership
}
\description{
Calculates the \emph{s-core} decomposition of a network. This is analogous to
the \emph{k-core} decomposition, but takes into account the \emph{strength}
of vertices (i.e., in weighted networks). If an unweighted network is
supplied, then the output of the function \code{\link[igraph]{coreness}} is
returned.
}
\details{
The \emph{s-core} consists of all vertices \eqn{i} with \eqn{s_i > s}, where
\eqn{s} is some threshold value. The \eqn{s_0} core is the entire network,
and the threshold value of the \eqn{s_{n}} core is
\deqn{s_{n-1} = min_i s_i}
for all vertices \eqn{i} in the \eqn{s_{n-1}} core.

Note that in networks with a wide distribution of vertex strengths, in which
there are almost as many unique values as there are vertices, then several
separate cores will have a single vertex. See the reference provided below.
}
\references{
Eidsaa, M and Almaas, E. (2013) s-core network decomposition: a
  generalization of k-core analysis to weighted networks. \emph{Physical
  Review E}, \bold{88}, 062819.
  \url{https://dx.doi.org/10.1103/PhysRevE.88.062819}
}
\seealso{
\code{\link[igraph]{coreness}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
