% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas.R
\name{Atlas Helpers}
\alias{Atlas Helpers}
\alias{guess_atlas}
\alias{as_atlas}
\alias{create_atlas}
\title{Guess the atlas based on the data}
\usage{
guess_atlas(x)

as_atlas(object)

create_atlas(regions, coords, lobes, hemis)
}
\arguments{
\item{x, object}{An object to test or convert to an atlas table}

\item{regions}{Character vector of region names}

\item{coords}{Numeric matrix of spatial coordinates; must have 3 columns}

\item{lobes}{Character or factor vector of lobe membership}

\item{hemis}{Character or factor vector of hemisphere membership. There
should probably not be more than 3 unique elements (for left, right, and
bi-hemispheric regions)}
}
\value{
\code{guess_atlas} - Character string; either the matched atlas or
  \code{NA}

\code{as_atlas} and \code{create_atlas} return a \code{data.table}
  that conforms to other atlases in the package, or exits with an error.
}
\description{
\code{guess_atlas} tries to determine which atlas is being used based on the
data; i.e., the number of vertices/regions.

\code{as_atlas} and \code{create_atlas} converts an object to or creates a
\code{data.table} that is compatible with \code{brainGraph}.
}
\details{
There are several things \code{as_atlas} tries to do to make it work without
error:
\itemize{
  \item Coerce the object to \code{data.table}
  \item Add a column of integers named \code{index}
  \item Change columns named \code{'x'}, \code{'y'}, or \code{'z'} to have
    \code{.mni} at the end
}
}
\examples{
my_atlas <- data.frame(name=paste('Region', 1:10), x.mni=rnorm(10),
  y.mni=rnorm(10), z.mni=rnorm(10),
  lobe=rep(c('Frontal', 'Parietal', 'Temporal', 'Occipital', 'Limbic'), 2),
  hemi=c(rep('L', 5), rep('R', 5)))
my_atlas <- as_atlas(my_atlas)
str(my_atlas)
regions <- paste('Region', 1:10)
xyz <- matrix(rnorm(30), nrow=10, ncol=3)
lobe <- rep(c('Frontal', 'Parietal', 'Temporal', 'Occipital', 'Limbic'), 2)
hemi <- c(rep('L', 5), rep('R', 5))
my_atlas <- create_atlas(regions, xyz, lobe, hemi)
str(my_atlas)
}
