% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_club.R
\name{rich_club_norm}
\alias{rich_club_norm}
\title{Calculate the normalized rich club coefficient}
\usage{
rich_club_norm(g, N = 100, rand = NULL, ...)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{N}{Integer; the number of random graphs to generate (default: 100)}

\item{rand}{A list of \code{igraph} graph objects, if random graphs have
already been generated (default: NULL)}

\item{...}{Other parameters (passed to \code{\link{rich_club_coeff}})}
}
\value{
A list with four elements:
\item{phi.rand}{A matrix with \emph{N} rows and \emph{max(degree(g))}
columns, where each row contains the coefficients for a given random graph.}
\item{phi.orig}{A vector of the rich-club coefficients for the original
graph.}
\item{phi.norm}{A named vector of the normalized rich club coefficients.}
\item{p}{The p-value based on the \emph{N} random graphs generated.}
}
\description{
This function will (optionally) generate a number of random graphs, calculate
their rich club coefficients (\eqn{\phi}), and return \eqn{\phi} of the graph
of interest divided by the mean across random graphs, i.e. \eqn{\phi_{norm}}.
If random graphs have already been generated, you can supply a list as an
argument (since graph generation is time consuming).
}
\references{
Colizza V., Flammini A., Serrano M.A., Vespignani A. (2006)
\emph{Detecting rich-club ordering in complex networks}. Nature Physics,
2:110-115.
}
\seealso{
\code{\link{sim.rand.graph.par}}

Other Rich-club functions: \code{\link{plot_rich_norm}},
  \code{\link{rich_club_attrs}},
  \code{\link{rich_club_coeff}}, \code{\link{rich_core}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
