% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classfunctions.R
\name{coef_lin.bpnr}
\alias{coef_lin.bpnr}
\title{Obtain the linear coefficients of a Bayesian circular regression model}
\usage{
\method{coef_lin}{bpnr}(object)
}
\arguments{
\item{object}{a \code{bpnr object} obtained from the function
\code{\link{bpnr}}.}
}
\value{
A matrix with posterior summaries of the linear coefficients in a
  Bayesian circular regression model.
}
\description{
Gives the coefficients tables of the linear coefficients for a circular
regression model.
}
\examples{
library(bpnreg)
fit.Motor <- bpnr(pred.I = Phaserad ~ 1 + Cond, data = Motor,
its = 100, burn = 10, n.lag = 3)
coef_lin(fit.Motor)

}
