############# Check functions

#' Check if a data frame column contains only the values 1 0 and 2. Used to check the format of the results
#' @param d_column a column from a data frame
#'
#' @return TRUE (correct) or FALSE (with problems)
check_result_column <- function(d_column) {
  passed <- all(d_column %in% c(2, 0, 1))
  return(passed)
}

#' Check if a data frame column contains ties
#' @param d_column a column with the values for the ties
#' @return T (there are ties) or F (no ties)
check_if_there_are_ties <- function(d_column) {
  ties <- any(d_column %in% c(2))
  return(ties)
}


#' Check for NA in the specfic columns and returns T or F is there is at least 1 NA in those columns
#'
#' @param d a data frame
#' @param player0 the name of column for player0
#' @param player1 the name of column for player1
#' @param player0_score the name of column for player0 scores
#' @param player1_score the name of column for player1 scores
#' @param result_column the name of column for results
#' @return TRUE (there are NA) or FALSE (no NA)
check_if_there_are_na <-
  function(d,
           player0,
           player1,
           player0_score = NULL,
           player1_score = NULL,
           result_column = NULL)
  {
    d <- as.data.frame(d)
    na_cols <-
      c(player0,
        player1,
        player0_score,
        player1_score,
        result_column)
    for (col in na_cols) {
      check_na <- any(is.na(d[, col]))
      if (check_na == T)
        return(T)
    }
    return(F)
  }



#' Check if a data frame column contains only the values 1 or 0. For the z column
#' @param d_column a column of a data frame to be tested
#' @return TRUE (correct) or FALSE (with problems)
check_z_column <- function(d_column) {
  passed <- all(d_column %in% c(0, 1))
  return(passed)
}


#' Check if all values in the predictor matrix are numeric and not NA. Note that TRUE will be cast to 1 and FALSE will be cast to 0
#' @param predictor_matrix a predictor matrix generated by the create_predictor_matrix_with_player_lookup_table function
#' @return TRUE (correct) or FALSE (with problems)
check_numeric_predictor_matrix <- function(predictor_matrix) {
  passed <-
    all(is.numeric(predictor_matrix)) & all(!is.na(predictor_matrix))
  return(passed)
}


#' Check if the predictor df contains all players and only those
#' @param predictor_df the predictor input data frame
#' @param lookup_table a lookup table of the players
#' @return TRUE (correct) or FALSE (with problems)
check_predictors_df_contains_all_players <-
  function(predictor_df, lookup_table) {
    predictor_df <- as.data.frame(predictor_df)
    passed <- TRUE
    nplayers <- nrow(lookup_table)
    nplayer_predictor_df <- nrow(predictor_df)
    if (nplayers != nplayer_predictor_df)
      passed <- FALSE
    player_column <- predictor_df[, 1]
    if (!all(player_column %in% lookup_table$Names))
      passed <- FALSE
    return(passed)
  }
