% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_report.R
\name{bp_report}
\alias{bp_report}
\title{Blood Pressure Report}
\usage{
bp_report(
  data,
  subj = NULL,
  inc_all = TRUE,
  save_report = 1,
  path = NULL,
  filename = "bp_report",
  width = 11,
  height = 8.5,
  filetype = "pdf",
  units = "in",
  scale = 1.25
)
}
\arguments{
\item{data}{Required argument. A processed dataframe resulting from the \code{process_data}
function to properly format data set. In order for the \code{bp_report} function to work properly,
the following variables must be present and properly formatted:
\itemize{

\item{\code{SBP}}
\item{\code{DBP}}
\item{\code{DATE_TIME}} - Used in the \code{process_data} function to create additional columns
that are needed for the \code{bp_report} function (SBP_Category, DBP_Category, Weekday, and
Time_of_Day.)
\item{\code{SBP_CATEGORY}} - Automatically calculated in the \code{process_data} function
\item{\code{DBP_CATEGORY}} - Automatically calculated in the \code{process_data} function
\item{\code{DAY_OF_WEEK}} - Automatically calculated in the \code{process_data} function
\item{\code{TIME_OF_DAY}} - Automatically calculated in the \code{process_data} function
\item{\code{ID}} - (If applicable) Used for separating out different individuals, if more than one
\item{\code{VISIT}} - (If applicable) Used for separating out an individuals' different visits,
if more than one

}}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}

\item{inc_all}{An indicator to dictate whether or not an overview page containing the data for
all subjects (aggregated together) should be included in the report. By default, \code{inc_all = TRUE}.}

\item{save_report}{A binary indicator (1 or 0) that determines whether or not to save the output.
The default is \code{save_report = 1} indicating that the report will be saved. Regardless of the
input, the report will still appear in the RStudio Plots pane.}

\item{path}{Optional argument. A string corresponding to the respective file path by which the
report is to be saved. Do not include trailing slashes (i.e. ~/loc/) or the file name (i.e. ~/loc/testfile.pdf).
By default, if not \code{path} argument specified, will save at the current working directory.}

\item{filename}{Optional argument. A string corresponding to the name of the report. The default is
"bp_report". The string cannot begin with a number or non-alphabetical character.
\cr
\cr Note: DO NOT include the file type extension (such as ".pdf" or ".png") at the end of the string;
the \code{bp_report} function will automatically join the name with the file type.}

\item{width}{Optional argument. An numeric value corresponding to the width of the output document.
The default is set to 12 inches.}

\item{height}{Optional argument. An numeric value corresponding to the height of the output document.
The default is set to 8.53 inches.}

\item{filetype}{A string corresponding to he particular type of file that the report is to be saved as.
Although PDF is the default possible options include:
\itemize{

\item{pdf} (default)
\item{png}
\item{jpeg}
\item{tiff}
\item{bmp}
\item{eps}
\item{ps}

}}

\item{units}{A character string corresponding to the unit of measurement that the width and height
correspond to in the exported output. The default is inches ("in"), but centimeters ("cm") and
millimeters ("mm") are also available.}

\item{scale}{A multiplicative scaling factor for the report output.}
}
\value{
A report visual containing various blood pressure metrics and visuals and a saved report (if
indicated) on the specified path. If no path specified, the report will be saved at the current
working directory which can be checked using \code{getwd()}
}
\description{
The \code{bp_report} function serves to aggregate various data visuals and metrics
pertaining to the supplied data set into a clean formatted report.
}
\examples{

data("bp_jhs")
data("hypnos_data")
hyp_proc <- process_data(hypnos_data,
                         sbp = "syst",
                         dbp = "DIAST",
                         bp_datetime = "date.time",
                         id = "id",
                         wake = "wake",
                         visit = "visit",
                         hr = "hr",
                         map = "map",
                         rpp = "rpp",
                         pp = "pp",
                         ToD_int = c(5, 13, 18, 23))

jhs_proc <- process_data(bp_jhs,
                         sbp = "Sys.mmHg.",
                         dbp = "Dias.mmHg.",
                         bp_datetime = "DateTime",
                         hr = "pulse.bpm.")
rm(hypnos_data, bp_jhs)
# Single-subject Report
# Note: save_report set to 0 for illustrative purposes of the example, not to actually save
bp_report(jhs_proc, filetype = 'png', save_report = 0)

# Multi-subject Report
# Note: save_report set to 0 for illustrative purposes of the example, not to actually save
## Not Run
\dontrun{
bp_report(hyp_proc, save_report = 0)
}

}
