% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.r
\name{paths}
\alias{paths}
\alias{mod_search_path}
\alias{calling_mod_path}
\alias{split_path}
\alias{merge_path}
\title{Path related functions}
\usage{
mod_search_path(caller)

calling_mod_path(caller)

split_path(path)

merge_path(components)
}
\arguments{
\item{caller}{the environment from which \code{box::use} was invoked.}

\item{path}{the path to split}

\item{components}{character string vector of path components to merge}
}
\value{
\code{calling_mod_path} the path of the source module that is calling
\code{box::use}, or the script’s path if the calling code is not a module.

\code{split_path} returns a character vector of path components that
logically represent \code{path}.

\code{merge_path} returns a single character string that is
logically equivalent to the \code{path} passed to \code{split_path}.
logically represent \code{path}.
}
\description{
\code{mod_search_path} returns the character vector of paths where module
code can be located and will be found by \pkg{box}.
}
\note{
The search paths are ordered from highest to lowest priority.
The current module’s path always has the lowest priority.

There are two ways of modifying the module search path: by default,
\code{getOption('box.path')} specifies the search path as a character vector.
Users can override its value by separately setting the environment variable
\env{R_BOX_PATH} to one or more paths, separated by the platform’s path
separator (\dQuote{:} on UNIX-like systems, \dQuote{;} on Windows).

\code{merge_path} is the inverse function to \code{split_path}.
However, this does not mean that its result will be identical to the
original path. Instead, it is only guaranteed that it will refer to the same
logical path given the same working directory.
}
\keyword{internal}
