% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{bootstrap_weights}
\alias{bootstrap_weights}
\title{Bootstrap with Adjusted Weights}
\usage{
bootstrap_weights(ys, N, B, method = c("RaoWuYue", "ChipperfieldPreston"))
}
\arguments{
\item{ys}{values of the variable of interest for the original sample}

\item{N}{scalar, representing the population size}

\item{B}{integer scalar, number of bootstrap resamples to draw from the pseudo-population}

\item{method}{a string indicating the bootstrap method to be used; 
available methods are "RaoWuYue" and "ChipperfieldPreston".}

\item{...}{added to ignore useless arguments}
}
\value{
a list of two elements, a vector of K average bootstrap totals and
a vector of K variance estimates.
}
\description{
Compute bootstrap estimates according to Bootstrap Weights procedures by
Rao et Al. (1992) and Chipperfield and Preston (2007).
}
\references{
Rao J. N. K.; Wu C. F. J.; Yue K. (1992).  Some recent work on resampling methods 
for complex surveys. Journal of the American Statistical Association, 83(401), 620-630.

Chipperfield J.; Preston J. (2007).Efficient bootstrap for business surveys.
Survey Methodology, 33(2), 167-172.
}
\keyword{internal}
