% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_cluster_multi.R
\name{ensemble.cluster.multi}
\alias{ensemble.cluster.multi}
\title{Multi-Method Ensemble Clustering with Graph-based Consensus}
\usage{
ensemble.cluster.multi(
  x,
  k_km,
  k_hc,
  k_sc,
  n_ref = 3,
  B = 100,
  hc.method = "ward.D",
  dist_method = "euclidean"
)
}
\arguments{
\item{x}{data.frame or matrix where rows are observations and columns are features}

\item{k_km}{number of clusters for k-means clustering}

\item{k_hc}{number of clusters for hierarchical clustering}

\item{k_sc}{number of clusters for spectral clustering}

\item{n_ref}{number of reference distributions for stability assessment (default: 3)}

\item{B}{number of bootstrap samples for stability estimation (default: 100)}

\item{hc.method}{hierarchical clustering method (default: "ward.D")}

\item{dist_method}{distance method for spectral clustering (default: "euclidean")}
}
\value{
A list containing:
\describe{
  \item{membership}{Final cluster assignments from ensemble consensus}
  \item{k_consensus}{Number of clusters found in consensus}
  \item{individual_results}{List of results from individual clustering methods}
  \item{stability_measures}{Stability measures for each method}
  \item{graph}{igraph object of the ensemble graph}
}
}
\description{
Implements ensemble clustering by combining multiple clustering methods 
(k-means, hierarchical, and spectral clustering) using a graph-based consensus approach.
}
\details{
This function implements a multi-method ensemble clustering approach that:
1. Applies multiple clustering methods (k-means, hierarchical, spectral)
2. Assesses stability of each clustering through bootstrapping
3. Constructs a weighted bipartite graph representing all clusterings
4. Uses fast greedy community detection for final consensus
}
\examples{
\donttest{
data(iris)
df <- iris[,1:4]
result <- ensemble.cluster.multi(df, k_km=3, k_hc=3, k_sc=3)
plot(df[,1:2], col=result$membership, pch=16)
}

}
