% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootMice.R
\name{bootMice}
\alias{bootMice}
\title{Bootstrap then impute using mice}
\usage{
bootMice(obsdata, nBoot = 200, nImp = 2, nCores = 1, seed = NULL, ...)
}
\arguments{
\item{obsdata}{The data frame to be imputed.}

\item{nBoot}{The number of bootstrap samples to take. It is recommended
that you use a minimum of 200. If you specify \code{nCores>1}, \code{nBoot} must
be a multiple of the specified \code{nCores} value.}

\item{nImp}{The number of times to impute each bootstrap sample. Two
is recommended.}

\item{nCores}{The number of CPU cores to use. If specified greater than one,
bootImpute will impute using the number of cores specified.}

\item{seed}{Random number seed.}

\item{...}{Other arguments that are to be passed to \code{mice}.}
}
\value{
A list of imputed datasets.
}
\description{
Bootstraps an incomplete dataset and then imputes each bootstrap a number
of times using the mice package. The resulting list of bootstrapped then
imputed datasets can be analysed with \code{\link{bootImputeAnalyse}}.
To run this function requires the \code{mice} package to be installed.
}
\examples{
library(mice)

head(ex_linquad)

#bootstrap 10 times and impute each twice
imps <- bootMice(ex_linquad, nBoot=10, nImp=2, seed=564764)
}
