% Generated by roxygen2 (4.0.0): do not edit by hand
\name{wrapReweighter}
\alias{wrapReweighter}
\title{Create a boostr compatible wrapper for a reweighter.}
\usage{
wrapReweighter(reweighter, reweighterInputPreds = "prediction",
  reweighterInputResponse = "response", reweighterInputWts = "weights",
  reweighterOutputWts = "weights", .verbose = FALSE)
}
\arguments{
\item{reweighter}{a function which satisfies the abstract definition of a
reweighter (see description below).}

\item{reweighterInputPreds}{a string indicating the name of the argument
\code{reweighter} uses to represent the input predictions.}

\item{reweighterInputResponse}{a string indicating the name of the argument
\code{reweighter} uses to represent the true responses for the input predictions.}

\item{reweighterInputWts}{a string indicating the name of the argument
\code{reweighter} uses to represent the input weights.}

\item{reweighterOutputWts}{a string indicating the name of the entry in
\code{reweighter}'s output that represents the output weights.}

\item{.verbose}{a boolean indicating if warnings should be displayed or not.}
}
\value{
A function (wrapper around \code{reweighter}) which is a '\code{reweighter}'
object. The wrapper's signature is \code{(prediction, response, weights, ...)}
and its output is a list that names the cell containing its weights
'\code{weight}'. Hence, the wrapper is a boostr compatible reweighter.
}
\description{
Use provided metadata on a given reweighter to create a boostr
compatible wrapper.
}
\section{Reweighters}{


See the Reweighters section in the vignette
\code{vignette(topic = "boostr_user_inputs", package="boostr")} for
more details on reweighters.
}
\references{
Steven Pollack. (2014). Boost: a practical generalization of AdaBoost
(Master's Thesis). \url{http://pollackphoto.net/misc/masters_thesis.pdf}
}
\seealso{
Other Wrapper Generators: \code{\link{buildEstimationProcedure}};
  \code{\link{wrapAggregator}};
  \code{\link{wrapPerformanceAnalyzer}};
  \code{\link{wrapProcedure}}
}

