% Generated by roxygen2 (4.0.0): do not edit by hand
\name{wrapAggregator}
\alias{wrapAggregator}
\title{Create a boostr compatible wrapper for an aggregator.}
\usage{
wrapAggregator(aggregator, .inputEnsemble = "estimators", .verbose = FALSE)
}
\arguments{
\item{aggregator}{a function which satisfies the abstract definition of an
aggregator.}

\item{.inputEnsemble}{a string indicating the name of the argument that
\code{aggregator} uses for the ensemble of estimators created during the
Boost algorithm.}

\item{.verbose}{a logical flag indicating whether warnings should be output
or not.}
}
\value{
A function with is also an '\code{aggregator}' object. The function's
signature and output are now compatible with the boostr framework. In
particular, the signature of the wrapper is
\item{estimators}{the list of estimators to be sent to \code{aggregator}.}
\item{...}{any additional arguments accepted/required by \code{aggregator}.}
The output of this aggregator is an estimator with signature
\item{newdata}{the data the \code{aggregator}'s output would use for prediction.}
}
\description{
Use provided metadata on a given aggregator to create a boostr
compatible wrapper. See section below for details on aggregators.
}
\section{Aggregators}{


See the Aggregators section in the vignette
\code{vignette(topic = "boostr_user_inputs", package="boostr")} for
more details on aggregators.
}
\examples{
\dontrun{
testAggregator <- function(ensemble) {
 weights <- runif(min=0, max=1, n=length(ensemble))
 function(x) {
   preds <- foreach(estimator = iter(ensemble),
                  .combine = rbind) \%do\% {
                    matrix(as.character(estimator(x)), nrow=1)
                  }

   as.factor(predictClassFromWeightedVote(preds, weights))
 }
}

wrappedAggregator <- wrapAggregator(testAggregator,
                                    .inputEnsemble="ensemble")
}
}
\references{
Steven Pollack. (2014). Boost: a practical generalization of AdaBoost
(Master's Thesis). \url{http://pollackphoto.net/misc/masters_thesis.pdf}
}
\seealso{
Other Wrapper Generators: \code{\link{buildEstimationProcedure}};
  \code{\link{wrapPerformanceAnalyzer}};
  \code{\link{wrapProcedure}}; \code{\link{wrapReweighter}}
}

