% Generated by roxygen2 (4.0.0): do not edit by hand
\name{isClassConstructor}
\alias{isClassConstructor}
\title{check if a function is a(n S3) class constructor}
\usage{
isClassConstructor(func)
}
\arguments{
\item{func}{any function}
}
\value{
a boolean. If the return value is \code{TRUE} the boolean has
attribute \code{classes} which returns the (potential) classes for the
output of \code{func}
}
\description{
takes a function and returns a boolean indicating whether its
output gets assigned a class.
}
\details{
The body of \code{func} is search for one of three idioms:
\enumerate{
 \item \code{UseMethod("className")}
 \item \code{class(output) <- classes}
 \item \code{attr(output, "class") <- classes}
}
If either is found, the assigned class (or classes) are returned as the
\code{classes} attribute of the output. If none are found, a value of
\code{FALSE} is returned (with no attributes).
}
\examples{
isClassConstructor(mean) # FALSE

# simple output
library(randomForest)
isClassConstructor(randomForest) # TRUE

# complicated output (multiple values in "classes")
isClassConstructor(glm) # TRUE
isClassConstructor(lm) # TRUE
}

