% Generated by roxygen2 (4.0.0): do not edit by hand
\name{boostBackend}
\alias{boostBackend}
\title{Boost an estimation procedure with a reweighter and aggregator.}
\usage{
boostBackend(B, reweighter, aggregator, proc, data, initialWeights, .procArgs,
  analyzePerformance = defaultOOBPerformanceAnalysis,
  .reweighterArgs = NULL, .aggregatorArgs = NULL,
  .analyzePerformanceArgs = NULL, .subsetFormula = findFormulaIn(.procArgs),
  .formatData = !is.null(.subsetFormula), .storeData = FALSE,
  .calcBoostrPerformance = TRUE)
}
\arguments{
\item{B}{the number of iterations to run.}

\item{reweighter}{a boostr compatible reweighter function.}

\item{aggregator}{a boostr compatible aggregator function.}

\item{proc}{a boostr compatible estimation procedure.}

\item{data}{the learning set to pass to \code{proc}. \code{data} is assumed
to hold the response variable in its first column.}

\item{initialWeights}{a vector of weights used for the first iteration of
the ensemble building phase of Boost.}

\item{.procArgs}{a named list of arguments to pass to \code{proc} in
addition to \code{data}.}

\item{.reweighterArgs}{a named list of arguments to pass to
\code{reweighter} in addition to \code{proc}, \code{data} and
\code{weights}. These are generally initialization values for other
parameters that govern the behaviour of \code{reweighter}.}

\item{.aggregatorArgs}{a named list of arguments to pass to
\code{aggregator} in addition to the output from \code{reweighter}.}

\item{.storeData}{a boolean indicating whether the data should be stored in
the returned \code{boostr} object under the attribute "\code{data}".}

\item{.calcBoostrPerformance}{a boolean indicating whether
\code{analyzePerformance} should be used to monitor the performance of the
returned \code{boostr} object on the learning set. A value of
\code{seq.int(nrow(data))} will be passed to \code{analyzePerformance} as
the \code{oobObs} argument.}

\item{.subsetFormula}{a \code{formula} object indicating how \code{data} is
to be subsetted. A formula of like "Type ~ ." will rearrange the columns of
\code{data} such that \code{data[,1] == data$Type}. By default, this value
is taken to be the value of the \code{formula} entry in \code{.procArgs}.
If multiple entries have the substring "formula" in their names, the search
will throw an error and you're advised to manually set \code{.subsetFormula}.}

\item{.formatData}{a boolean indicating whether the data needs to be
reformatted via \code{.subsetFormula} such that the response variable is in
the first column and the remaining columns are all predictor variables. This
is defaulted to \code{!is.null(.subsetFormula)}.}

\item{analyzePerformance}{a boostr compatible performance analyzer.}

\item{.analyzePerformanceArgs}{a named list arguments to pass to
\code{analyzePerformance} in addition to \code{prediction}, \code{response},
and \code{oobPbs}.}
}
\value{
a "\code{boostr}" object. The returned closure is the output of
\code{aggregator} on the collection of estimators built during the iterative
phase of Boost. This is intended to be a new estimator, and hence accepts
the argument \code{newdata}. However, the estimator also has attributes
\item{ensembleEstimators}{An ordered list whose components are the trained
 estimators.}
\item{reweighterOutput}{An ordered list whose components are the output of
\code{reweighter} at each iteration.}
\item{performanceOnLearningSet}{The performance of the returned boostr object
on the learning set, as measure by \code{analyzePerformance}. This is only
calculated if \code{.calcBoostrPerformance=TRUE}}
\item{estimatorPerformance}{An ordered list whose components are the output
of \code{analyzePerformance} at each iteration.}
\item{oobVec}{A row-major matrix whose \eqn{ij}{ij}-th entry indicates if
observation \eqn{j}{j} was used to train estimator \eqn{i}{i}.}
\item{reweighter}{The reweighter function used.}
\item{reweighterArgs}{Any additional arguments passed to \code{boostBackend}
for \code{reweighter}.}
\item{aggregator}{The aggregator function used.}
\item{aggregatorArgs}{Any additional arguments passed to \code{boostBackend}
for \code{aggregator}.}
\item{estimationProcedure}{The estimation procedure used.}
\item{estimationProcedureArgs}{Any additional arguments passed to
\code{boostBackend} for \code{proc}.}
\item{data}{The learning set. Only stored if \code{.storeData = TRUE}.}
\item{analyzePerformance}{The performance analyzer used.}
\item{analyzePerformanceArgs}{Any additional arguments passed to
\code{boostBackend} for \code{analyzePerformance}.}
\item{subsetFormula}{The value of \code{.subsetFormula}.}
\item{formatData}{The value of \code{.formatData}.}
\item{storeData}{The value of \code{.storeData}.}
\item{calcBoostrPerformance}{The value of \code{.calcBoostrPerformance}}
\item{initialWeights}{The initial weights used.}

 The attributes can be accessed through the appropropriate
 \code{\link[=ensembleEstimators]{extraction function}}.
}
\description{
Perform the Boost algorithm on \code{proc} with \code{reweighter} and
\code{aggregator} and monitor estimator performance with
\code{analyzePerformance}.
}
\details{
For the details behind this algorithm, check out the paper at
\url{http://pollackphoto.net/misc/masters_thesis.pdf}
}
\note{
\code{\link{wrapReweighter}}, \code{\link{wrapAggregator}},
\code{\link{wrapPerformanceAnalyzer}}, \code{\link{wrapProcedure}}, and
\code{\link{buildEstimationProcedure}} are all Wrapper Generators
designed to allow user implemented functions inside the \code{boostBackend}.
These functions are intelligently called from inside \code{\link{boost}}.
Thus, to minimize any sources of frustration, the recommended use of
\code{boostBackend} is through \code{\link{boost}}.
}
\examples{
\dontrun{
df <- within(iris, {
              Setosa <- factor(2*as.numeric(Species == "setosa") - 1)
              Species <- NULL
             })

form <- formula(Setosa ~ . )
df <- model.frame(formula=form, data=df)

# demonstrate arc-fs algorithm using boostr convenience functions

glmArgs <- list(.trainArgs=list(formula=form, family="binomial"))

# format prediction to yield response in {-1,1} instead of {0,1}
glm_predict <- function(object, newdata) {
  2*round(predict(object, newdata, type='response')) - 1
  }

Phi_glm <- buildEstimationProcedure(train=glm, predict=glm_predict)

phi <- boostBackend(B=3, data=df,
                     reweighter=adaboostReweighter,
                     aggregator=adaboostAggregator,
                     proc=Phi_glm,
                     .procArgs=glmArgs)
}
}
\references{
Steven Pollack. (2014). Boost: a practical generalization of AdaBoost
(Master's Thesis). \url{http://pollackphoto.net/misc/masters_thesis.pdf}
}

