% Generated by roxygen2 (4.0.0): do not edit by hand
\name{adaboostReweighter}
\alias{adaboostReweighter}
\title{Reweighter function for the Adaboost.M1 algorithm}
\usage{
adaboostReweighter(prediction, response, weights, ...)
}
\arguments{
\item{prediction}{a vector of predictions.}

\item{response}{a vector whose \eqn{i^{th}}{ith} component is the true
response for the \eqn{i^{th}}{ith} component of \code{prediction}.}

\item{weights}{a vector of weights. They don't necessarily need to sum to 1.}

\item{...}{implemented to allow reweighter to accept its output as its input.}
}
\value{
For internal bookkeeping, this function is inherits from the
'\code{reweighter}' class. It returns a named list with components
\item{weights}{the updated weights calculated from the input weights,
\code{prediction} and \code{response}.}

\item{alpha}{performance measure of \code{estimator} to be used by
\code{\link{adaboostAggregator}}.}
}
\description{
Implements a slightly modified version of the reweighter described
in the Adaboost.M1 algorithm.
}
\details{
The modification of the reweighter comes in to play when
\eqn{$\epsilon = 0$}{\epsilon = 0}. This is when the esimator correctly
classifies every observation in the learning set. Consequently, we're
supposed to define
\eqn{
\alpha = \displaystyle log\left(\frac{1-\epsilon}{\epsilon}\right)}{
\alpha = log(1-\epsilon) - log(\epsilon)
}
However, this is \eqn{+\infty}{+\infty}, which is not a number R is used
to working with. To work around this, we have to create a conditional statement
that sets \code{alpha <- log(.Machine$double.xmax)} and let the algorithm
proceed as originally described. The effect of this modification is the following:
\enumerate{
 \item{the update that's supposed to be made to \code{weights}, which is a
 function of \code{alpha}, effectively keeps \code{weights} as they were
  before.}
 \item{if you pair this reweighter with \code{\link{adaboostAggregator}} then
 the estimator associated to this very large \code{alpha} now has tremendous
 weight inside the weighted sum in the aggregator. This isn't, necessarily,
 a bad thing -- the estimator classified every observation in \code{data}
 correctly.}
}
}
\seealso{
Other adaboost: \code{\link{adaboostAggregator}}

Other reweighters: \code{\link{arcfsReweighter}};
  \code{\link{arcx4Reweighter}}; \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}};
  \code{\link{vanillaBagger}}
}

