% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_radar_imagery.R
\name{get_available_radar}
\alias{get_available_radar}
\title{Get a listing of available BOM radar imagery}
\usage{
get_available_radar(radar_id = "all")
}
\arguments{
\item{radar_id}{Character. \acronym{BOM} radar \acronym{ID} of interest for
which a list of available images will be returned.  Defaults to all images
currently available.}
}
\value{
A data frame of all selected \acronym{radar} locations with location
information and \var{product_ids}.
}
\description{
Fetch a listing of available \acronym{BOM} \acronym{radar} imagery from
\url{ftp://ftp.bom.gov.au/anon/gen/radar/} to determine which files are
currently available for download.  The files available are the most recent
\acronym{radar} imagery for each location, which are updated approximately
every 6 to 10 minutes by the \acronym{BOM}.
}
\details{
Valid \acronym{BOM} \acronym{radar} ID for each location required.
}
\examples{
\donttest{
# Check availability radar imagey for Wollongong (radar_id = 3)
imagery <- get_available_radar(radar_id = "3")
}

}
\references{
Australian Bureau of Meteorology (BOM) radar images 
\url{http://www.bom.gov.au/australia/radar/}
}
\author{
Dean Marchiori, \email{deanmarchiori@gmail.com}
}
