% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clust_Method.R
\name{BossaSimi}
\alias{BossaSimi}
\title{Bossa Similarity}
\usage{
BossaSimi(data, is.pca = TRUE, pca.sum.prop = 0.95, fix.pca.comp = FALSE,
  n.comp = 50, alpha = 1, pro.show = FALSE)
}
\arguments{
\item{data}{A data.frame or matrix(\code{n*p}) of original categorical data.}

\item{is.pca}{A logical variable indicating if the Bossa scores should transformed
to principle components and then calculate the similarity matrix. It is recommended
when processing the ultra-dimension data.}

\item{pca.sum.prop}{A numeric indicating how many components should be reserved
in order to make this proportion of variance. The default is \code{pca.sum.prop =  0.95}.}

\item{fix.pca.comp}{A numeric variable indicating whether choosing the fixed
number of components or the fixed proportion of variance and the default is to
choose fixed proportion.}

\item{n.comp}{The number of components of PCA. The default is \code{n.comp = 50}.}

\item{alpha}{A power scaling for Bossa scores, representing the weight of
variable sigma value.}

\item{pro.show}{A logical indicator whether show the details of the process.}
}
\value{
An object including Bossa scores, Bossa dissimilarity and Bossa similarity(for
\code{\link{OverlapClust}}.
}
\description{
Calculate the similarity matrix of Bossa scores which are obtained by boosting
on single attribute.
}
\examples{
{
## generate sparse data from the toy model of CIDR
sparse.data <- data.frame(g.1 = c(0, 5, 0, 6, 8, 6, 7, 7), g.2 = c(5, 0, 0, 0, 5, 7, 5, 7))

## with low-dimensional data, pca is uncessary
bossa.change <- BossaSimi(sparse.data, is.pca = FALSE)

## data after normalization
data.after <- bossa.change$U.score.non.pca

## similarity matrix of normalized data
data.simi <- bossa.change$bossa.simi
}
}
