// Generated by rstantools.  Do not edit by hand.

/*
    bmstdr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmstdr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmstdr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_ind_gpp_marginal_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'ind_gpp_marginal', line 51, column 2 to column 17)",
                                                      " (in 'ind_gpp_marginal', line 52, column 2 to column 20)",
                                                      " (in 'ind_gpp_marginal', line 53, column 2 to column 25)",
                                                      " (in 'ind_gpp_marginal', line 54, column 2 to column 36)",
                                                      " (in 'ind_gpp_marginal', line 56, column 2 to column 23)",
                                                      " (in 'ind_gpp_marginal', line 59, column 0 to column 18)",
                                                      " (in 'ind_gpp_marginal', line 60, column 0 to column 18)",
                                                      " (in 'ind_gpp_marginal', line 62, column 8 to column 10)",
                                                      " (in 'ind_gpp_marginal', line 62, column 12 to column 14)",
                                                      " (in 'ind_gpp_marginal', line 62, column 0 to column 22)",
                                                      " (in 'ind_gpp_marginal', line 63, column 8 to column 10)",
                                                      " (in 'ind_gpp_marginal', line 63, column 12 to column 14)",
                                                      " (in 'ind_gpp_marginal', line 63, column 0 to column 22)",
                                                      " (in 'ind_gpp_marginal', line 64, column 8 to column 9)",
                                                      " (in 'ind_gpp_marginal', line 64, column 11 to column 13)",
                                                      " (in 'ind_gpp_marginal', line 64, column 0 to column 20)",
                                                      " (in 'ind_gpp_marginal', line 65, column 0 to column 19)",
                                                      " (in 'ind_gpp_marginal', line 68, column 5 to column 42)",
                                                      " (in 'ind_gpp_marginal', line 70, column 5 to column 29)",
                                                      " (in 'ind_gpp_marginal', line 67, column 18 to line 71, column 4)",
                                                      " (in 'ind_gpp_marginal', line 67, column 0 to line 71, column 4)",
                                                      " (in 'ind_gpp_marginal', line 66, column 18 to line 72, column 2)",
                                                      " (in 'ind_gpp_marginal', line 66, column 0 to line 72, column 2)",
                                                      " (in 'ind_gpp_marginal', line 73, column 15 to column 33)",
                                                      " (in 'ind_gpp_marginal', line 73, column 0 to column 33)",
                                                      " (in 'ind_gpp_marginal', line 74, column 0 to column 27)",
                                                      " (in 'ind_gpp_marginal', line 77, column 4 to column 42)",
                                                      " (in 'ind_gpp_marginal', line 76, column 18 to line 78, column 5)",
                                                      " (in 'ind_gpp_marginal', line 76, column 2 to line 78, column 5)",
                                                      " (in 'ind_gpp_marginal', line 75, column 15 to line 79, column 3)",
                                                      " (in 'ind_gpp_marginal', line 75, column 0 to line 79, column 3)",
                                                      " (in 'ind_gpp_marginal', line 82, column 1 to column 9)",
                                                      " (in 'ind_gpp_marginal', line 85, column 11 to column 17)",
                                                      " (in 'ind_gpp_marginal', line 85, column 19 to column 25)",
                                                      " (in 'ind_gpp_marginal', line 85, column 3 to column 30)",
                                                      " (in 'ind_gpp_marginal', line 86, column 11 to column 17)",
                                                      " (in 'ind_gpp_marginal', line 86, column 19 to column 21)",
                                                      " (in 'ind_gpp_marginal', line 86, column 3 to column 26)",
                                                      " (in 'ind_gpp_marginal', line 88, column 3 to column 40)",
                                                      " (in 'ind_gpp_marginal', line 89, column 3 to column 36)",
                                                      " (in 'ind_gpp_marginal', line 91, column 5 to column 24)",
                                                      " (in 'ind_gpp_marginal', line 90, column 23 to line 92, column 4)",
                                                      " (in 'ind_gpp_marginal', line 90, column 3 to line 92, column 4)",
                                                      " (in 'ind_gpp_marginal', line 96, column 6 to column 25)",
                                                      " (in 'ind_gpp_marginal', line 97, column 6 to column 15)",
                                                      " (in 'ind_gpp_marginal', line 95, column 26 to line 98, column 7)",
                                                      " (in 'ind_gpp_marginal', line 95, column 6 to line 98, column 7)",
                                                      " (in 'ind_gpp_marginal', line 94, column 24 to line 99, column 4)",
                                                      " (in 'ind_gpp_marginal', line 94, column 4 to line 99, column 4)",
                                                      " (in 'ind_gpp_marginal', line 83, column 19 to line 100, column 1)",
                                                      " (in 'ind_gpp_marginal', line 83, column 1 to line 100, column 1)",
                                                      " (in 'ind_gpp_marginal', line 81, column 1 to line 101, column 1)",
                                                      " (in 'ind_gpp_marginal', line 61, column 0 to line 102, column 1)",
                                                      " (in 'ind_gpp_marginal', line 111, column 7 to column 8)",
                                                      " (in 'ind_gpp_marginal', line 111, column 0 to column 13)",
                                                      " (in 'ind_gpp_marginal', line 112, column 0 to column 8)",
                                                      " (in 'ind_gpp_marginal', line 113, column 1 to column 56)",
                                                      " (in 'ind_gpp_marginal', line 114, column 1 to column 50)",
                                                      " (in 'ind_gpp_marginal', line 115, column 20 to column 74)",
                                                      " (in 'ind_gpp_marginal', line 115, column 1 to column 74)",
                                                      " (in 'ind_gpp_marginal', line 116, column 20 to column 72)",
                                                      " (in 'ind_gpp_marginal', line 116, column 1 to column 72)",
                                                      " (in 'ind_gpp_marginal', line 117, column 20 to column 73)",
                                                      " (in 'ind_gpp_marginal', line 117, column 1 to column 73)",
                                                      " (in 'ind_gpp_marginal', line 118, column 16 to column 84)",
                                                      " (in 'ind_gpp_marginal', line 118, column 1 to column 84)",
                                                      " (in 'ind_gpp_marginal', line 120, column 4 to column 34)",
                                                      " (in 'ind_gpp_marginal', line 119, column 2 to line 120, column 34)",
                                                      " (in 'ind_gpp_marginal', line 124, column 4 to column 37)",
                                                      " (in 'ind_gpp_marginal', line 123, column 2 to line 124, column 37)",
                                                      " (in 'ind_gpp_marginal', line 122, column 17 to line 125, column 2)",
                                                      " (in 'ind_gpp_marginal', line 122, column 1 to line 125, column 2)",
                                                      " (in 'ind_gpp_marginal', line 128, column 10 to column 16)",
                                                      " (in 'ind_gpp_marginal', line 128, column 3 to column 21)",
                                                      " (in 'ind_gpp_marginal', line 129, column 10 to column 16)",
                                                      " (in 'ind_gpp_marginal', line 129, column 3 to column 22)",
                                                      " (in 'ind_gpp_marginal', line 130, column 11 to column 17)",
                                                      " (in 'ind_gpp_marginal', line 130, column 19 to column 25)",
                                                      " (in 'ind_gpp_marginal', line 130, column 3 to column 30)",
                                                      " (in 'ind_gpp_marginal', line 133, column 3 to column 36)",
                                                      " (in 'ind_gpp_marginal', line 134, column 3 to column 42)",
                                                      " (in 'ind_gpp_marginal', line 138, column 6 to column 25)",
                                                      " (in 'ind_gpp_marginal', line 139, column 6 to column 15)",
                                                      " (in 'ind_gpp_marginal', line 137, column 26 to line 140, column 7)",
                                                      " (in 'ind_gpp_marginal', line 137, column 6 to line 140, column 7)",
                                                      " (in 'ind_gpp_marginal', line 136, column 25 to line 141, column 6)",
                                                      " (in 'ind_gpp_marginal', line 136, column 5 to line 141, column 6)",
                                                      " (in 'ind_gpp_marginal', line 143, column 3 to column 30)",
                                                      " (in 'ind_gpp_marginal', line 126, column 19 to line 144, column 1)",
                                                      " (in 'ind_gpp_marginal', line 126, column 1 to line 144, column 1)",
                                                      " (in 'ind_gpp_marginal', line 15, column 0 to column 15)",
                                                      " (in 'ind_gpp_marginal', line 16, column 0 to column 16)",
                                                      " (in 'ind_gpp_marginal', line 17, column 0 to column 16)",
                                                      " (in 'ind_gpp_marginal', line 18, column 0 to column 15)",
                                                      " (in 'ind_gpp_marginal', line 19, column 0 to column 34)",
                                                      " (in 'ind_gpp_marginal', line 20, column 0 to column 20)",
                                                      " (in 'ind_gpp_marginal', line 21, column 0 to column 19)",
                                                      " (in 'ind_gpp_marginal', line 22, column 18 to column 24)",
                                                      " (in 'ind_gpp_marginal', line 22, column 0 to column 26)",
                                                      " (in 'ind_gpp_marginal', line 23, column 17 to column 22)",
                                                      " (in 'ind_gpp_marginal', line 23, column 0 to column 24)",
                                                      " (in 'ind_gpp_marginal', line 24, column 9 to column 10)",
                                                      " (in 'ind_gpp_marginal', line 24, column 0 to column 12)",
                                                      " (in 'ind_gpp_marginal', line 25, column 0 to column 9)",
                                                      " (in 'ind_gpp_marginal', line 26, column 8 to column 12)",
                                                      " (in 'ind_gpp_marginal', line 26, column 0 to column 14)",
                                                      " (in 'ind_gpp_marginal', line 27, column 8 to column 12)",
                                                      " (in 'ind_gpp_marginal', line 27, column 0 to column 14)",
                                                      " (in 'ind_gpp_marginal', line 28, column 14 to column 18)",
                                                      " (in 'ind_gpp_marginal', line 28, column 0 to column 20)",
                                                      " (in 'ind_gpp_marginal', line 29, column 12 to column 16)",
                                                      " (in 'ind_gpp_marginal', line 29, column 0 to column 18)",
                                                      " (in 'ind_gpp_marginal', line 31, column 0 to column 12)",
                                                      " (in 'ind_gpp_marginal', line 34, column 7 to column 8)",
                                                      " (in 'ind_gpp_marginal', line 34, column 10 to column 12)",
                                                      " (in 'ind_gpp_marginal', line 34, column 0 to column 20)",
                                                      " (in 'ind_gpp_marginal', line 35, column 7 to column 9)",
                                                      " (in 'ind_gpp_marginal', line 35, column 11 to column 13)",
                                                      " (in 'ind_gpp_marginal', line 35, column 0 to column 20)",
                                                      " (in 'ind_gpp_marginal', line 36, column 10 to column 15)",
                                                      " (in 'ind_gpp_marginal', line 36, column 0 to column 17)",
                                                      " (in 'ind_gpp_marginal', line 37, column 7 to column 8)",
                                                      " (in 'ind_gpp_marginal', line 37, column 10 to column 11)",
                                                      " (in 'ind_gpp_marginal', line 37, column 0 to column 15)",
                                                      " (in 'ind_gpp_marginal', line 38, column 0 to column 30)",
                                                      " (in 'ind_gpp_marginal', line 39, column 0 to column 28)",
                                                      " (in 'ind_gpp_marginal', line 40, column 0 to column 21)",
                                                      " (in 'ind_gpp_marginal', line 41, column 0 to column 34)",
                                                      " (in 'ind_gpp_marginal', line 44, column 2 to column 15)",
                                                      " (in 'ind_gpp_marginal', line 47, column 4 to column 38)",
                                                      " (in 'ind_gpp_marginal', line 46, column 20 to line 48, column 3)",
                                                      " (in 'ind_gpp_marginal', line 46, column 2 to line 48, column 3)",
                                                      " (in 'ind_gpp_marginal', line 51, column 9 to column 10)",
                                                      " (in 'ind_gpp_marginal', line 54, column 14 to column 34)",
                                                      " (in 'ind_gpp_marginal', line 59, column 7 to column 8)",
                                                      " (in 'ind_gpp_marginal', line 60, column 10 to column 16)"};
#include <stan_meta_header.hpp>
class model_ind_gpp_marginal final : public model_base_crtp<model_ind_gpp_marginal> {
private:
  int n;
  int tn;
  int m2;
  int p;
  int missing;
  int ntmiss;
  int ntobs;
  std::vector<int> data_miss_idx;
  std::vector<int> data_obs_idx;
  std::vector<int> time;
  int nots;
  std::vector<int> ots;
  std::vector<int> nts;
  std::vector<int> start_row;
  std::vector<int> fin_row;
  int n_misst;
  Eigen::Matrix<double, -1, -1> Cdist;
  Eigen::Matrix<double, -1, -1> dmat;
  std::vector<double> yobs;
  Eigen::Matrix<double, -1, -1> X;
  std::vector<double> sigma2_prior;
  std::vector<double> tau2_prior;
  int phidist;
  std::vector<double> prior_phi_param;
  int sumnt2;
  int z_miss_1dim__;
 
public:
  ~model_ind_gpp_marginal() { }
  
  inline std::string model_name() const final { return "model_ind_gpp_marginal"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_ind_gpp_marginal(stan::io::var_context& context__,
                         unsigned int random_seed__ = 0,
                         std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_ind_gpp_marginal_namespace::model_ind_gpp_marginal";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 91;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 91;
      current_statement__ = 91;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 92;
      context__.validate_dims("data initialization","tn","int",
          context__.to_vec());
      tn = std::numeric_limits<int>::min();
      
      current_statement__ = 92;
      tn = context__.vals_i("tn")[(1 - 1)];
      current_statement__ = 92;
      current_statement__ = 92;
      check_greater_or_equal(function__, "tn", tn, 0);
      current_statement__ = 93;
      context__.validate_dims("data initialization","m2","int",
          context__.to_vec());
      m2 = std::numeric_limits<int>::min();
      
      current_statement__ = 93;
      m2 = context__.vals_i("m2")[(1 - 1)];
      current_statement__ = 93;
      current_statement__ = 93;
      check_greater_or_equal(function__, "m2", m2, 0);
      current_statement__ = 94;
      context__.validate_dims("data initialization","p","int",
          context__.to_vec());
      p = std::numeric_limits<int>::min();
      
      current_statement__ = 94;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 94;
      current_statement__ = 94;
      check_greater_or_equal(function__, "p", p, 0);
      current_statement__ = 95;
      context__.validate_dims("data initialization","missing","int",
          context__.to_vec());
      missing = std::numeric_limits<int>::min();
      
      current_statement__ = 95;
      missing = context__.vals_i("missing")[(1 - 1)];
      current_statement__ = 95;
      current_statement__ = 95;
      check_greater_or_equal(function__, "missing", missing, 0);
      current_statement__ = 95;
      current_statement__ = 95;
      check_less_or_equal(function__, "missing", missing, 1);
      current_statement__ = 96;
      context__.validate_dims("data initialization","ntmiss","int",
          context__.to_vec());
      ntmiss = std::numeric_limits<int>::min();
      
      current_statement__ = 96;
      ntmiss = context__.vals_i("ntmiss")[(1 - 1)];
      current_statement__ = 96;
      current_statement__ = 96;
      check_greater_or_equal(function__, "ntmiss", ntmiss, 0);
      current_statement__ = 97;
      context__.validate_dims("data initialization","ntobs","int",
          context__.to_vec());
      ntobs = std::numeric_limits<int>::min();
      
      current_statement__ = 97;
      ntobs = context__.vals_i("ntobs")[(1 - 1)];
      current_statement__ = 97;
      current_statement__ = 97;
      check_greater_or_equal(function__, "ntobs", ntobs, 0);
      current_statement__ = 98;
      validate_non_negative_index("data_miss_idx", "ntmiss", ntmiss);
      current_statement__ = 99;
      context__.validate_dims("data initialization","data_miss_idx","int",
          context__.to_vec(ntmiss));
      data_miss_idx = std::vector<int>(ntmiss, std::numeric_limits<int>::min());
      
      current_statement__ = 99;
      assign(data_miss_idx, nil_index_list(),
        context__.vals_i("data_miss_idx"), "assigning variable data_miss_idx");
      current_statement__ = 100;
      validate_non_negative_index("data_obs_idx", "ntobs", ntobs);
      current_statement__ = 101;
      context__.validate_dims("data initialization","data_obs_idx","int",
          context__.to_vec(ntobs));
      data_obs_idx = std::vector<int>(ntobs, std::numeric_limits<int>::min());
      
      current_statement__ = 101;
      assign(data_obs_idx, nil_index_list(),
        context__.vals_i("data_obs_idx"), "assigning variable data_obs_idx");
      current_statement__ = 102;
      validate_non_negative_index("time", "n", n);
      current_statement__ = 103;
      context__.validate_dims("data initialization","time","int",
          context__.to_vec(n));
      time = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 103;
      assign(time, nil_index_list(), context__.vals_i("time"),
        "assigning variable time");
      current_statement__ = 104;
      context__.validate_dims("data initialization","nots","int",
          context__.to_vec());
      nots = std::numeric_limits<int>::min();
      
      current_statement__ = 104;
      nots = context__.vals_i("nots")[(1 - 1)];
      current_statement__ = 105;
      validate_non_negative_index("ots", "nots", nots);
      current_statement__ = 106;
      context__.validate_dims("data initialization","ots","int",
          context__.to_vec(nots));
      ots = std::vector<int>(nots, std::numeric_limits<int>::min());
      
      current_statement__ = 106;
      assign(ots, nil_index_list(), context__.vals_i("ots"),
        "assigning variable ots");
      current_statement__ = 107;
      validate_non_negative_index("nts", "nots", nots);
      current_statement__ = 108;
      context__.validate_dims("data initialization","nts","int",
          context__.to_vec(nots));
      nts = std::vector<int>(nots, std::numeric_limits<int>::min());
      
      current_statement__ = 108;
      assign(nts, nil_index_list(), context__.vals_i("nts"),
        "assigning variable nts");
      current_statement__ = 109;
      validate_non_negative_index("start_row", "nots", nots);
      current_statement__ = 110;
      context__.validate_dims("data initialization","start_row","int",
          context__.to_vec(nots));
      start_row = std::vector<int>(nots, std::numeric_limits<int>::min());
      
      current_statement__ = 110;
      assign(start_row, nil_index_list(), context__.vals_i("start_row"),
        "assigning variable start_row");
      current_statement__ = 111;
      validate_non_negative_index("fin_row", "nots", nots);
      current_statement__ = 112;
      context__.validate_dims("data initialization","fin_row","int",
          context__.to_vec(nots));
      fin_row = std::vector<int>(nots, std::numeric_limits<int>::min());
      
      current_statement__ = 112;
      assign(fin_row, nil_index_list(), context__.vals_i("fin_row"),
        "assigning variable fin_row");
      current_statement__ = 113;
      context__.validate_dims("data initialization","n_misst","int",
          context__.to_vec());
      n_misst = std::numeric_limits<int>::min();
      
      current_statement__ = 113;
      n_misst = context__.vals_i("n_misst")[(1 - 1)];
      current_statement__ = 114;
      validate_non_negative_index("Cdist", "n", n);
      current_statement__ = 115;
      validate_non_negative_index("Cdist", "m2", m2);
      current_statement__ = 116;
      context__.validate_dims("data initialization","Cdist","double",
          context__.to_vec(n, m2));
      Cdist = Eigen::Matrix<double, -1, -1>(n, m2);
      stan::math::fill(Cdist, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Cdist_flat__;
        current_statement__ = 116;
        assign(Cdist_flat__, nil_index_list(), context__.vals_r("Cdist"),
          "assigning variable Cdist_flat__");
        current_statement__ = 116;
        pos__ = 1;
        current_statement__ = 116;
        for (int sym1__ = 1; sym1__ <= m2; ++sym1__) {
          current_statement__ = 116;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 116;
            assign(Cdist,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Cdist_flat__[(pos__ - 1)], "assigning variable Cdist");
            current_statement__ = 116;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 117;
      validate_non_negative_index("dmat", "m2", m2);
      current_statement__ = 118;
      validate_non_negative_index("dmat", "m2", m2);
      current_statement__ = 119;
      context__.validate_dims("data initialization","dmat","double",
          context__.to_vec(m2, m2));
      dmat = Eigen::Matrix<double, -1, -1>(m2, m2);
      stan::math::fill(dmat, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> dmat_flat__;
        current_statement__ = 119;
        assign(dmat_flat__, nil_index_list(), context__.vals_r("dmat"),
          "assigning variable dmat_flat__");
        current_statement__ = 119;
        pos__ = 1;
        current_statement__ = 119;
        for (int sym1__ = 1; sym1__ <= m2; ++sym1__) {
          current_statement__ = 119;
          for (int sym2__ = 1; sym2__ <= m2; ++sym2__) {
            current_statement__ = 119;
            assign(dmat,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              dmat_flat__[(pos__ - 1)], "assigning variable dmat");
            current_statement__ = 119;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 120;
      validate_non_negative_index("yobs", "ntobs", ntobs);
      current_statement__ = 121;
      context__.validate_dims("data initialization","yobs","double",
          context__.to_vec(ntobs));
      yobs = std::vector<double>(ntobs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 121;
      assign(yobs, nil_index_list(), context__.vals_r("yobs"),
        "assigning variable yobs");
      current_statement__ = 122;
      validate_non_negative_index("X", "n", n);
      current_statement__ = 123;
      validate_non_negative_index("X", "p", p);
      current_statement__ = 124;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(n, p));
      X = Eigen::Matrix<double, -1, -1>(n, p);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 124;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 124;
        pos__ = 1;
        current_statement__ = 124;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 124;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 124;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 124;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 125;
      context__.validate_dims("data initialization","sigma2_prior","double",
          context__.to_vec(2));
      sigma2_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 125;
      assign(sigma2_prior, nil_index_list(),
        context__.vals_r("sigma2_prior"), "assigning variable sigma2_prior");
      current_statement__ = 125;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 125;
        current_statement__ = 125;
        check_greater_or_equal(function__, "sigma2_prior[sym1__]",
                               sigma2_prior[(sym1__ - 1)], 0);}
      current_statement__ = 126;
      context__.validate_dims("data initialization","tau2_prior","double",
          context__.to_vec(2));
      tau2_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 126;
      assign(tau2_prior, nil_index_list(), context__.vals_r("tau2_prior"),
        "assigning variable tau2_prior");
      current_statement__ = 126;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 126;
        current_statement__ = 126;
        check_greater_or_equal(function__, "tau2_prior[sym1__]",
                               tau2_prior[(sym1__ - 1)], 0);}
      current_statement__ = 127;
      context__.validate_dims("data initialization","phidist","int",
          context__.to_vec());
      phidist = std::numeric_limits<int>::min();
      
      current_statement__ = 127;
      phidist = context__.vals_i("phidist")[(1 - 1)];
      current_statement__ = 127;
      current_statement__ = 127;
      check_greater_or_equal(function__, "phidist", phidist, 0);
      current_statement__ = 128;
      context__.validate_dims("data initialization","prior_phi_param",
          "double",context__.to_vec(2));
      prior_phi_param = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 128;
      assign(prior_phi_param, nil_index_list(),
        context__.vals_r("prior_phi_param"),
        "assigning variable prior_phi_param");
      current_statement__ = 128;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 128;
        current_statement__ = 128;
        check_greater_or_equal(function__, "prior_phi_param[sym1__]",
                               prior_phi_param[(sym1__ - 1)], 0);}
      current_statement__ = 129;
      sumnt2 = std::numeric_limits<int>::min();
      
      current_statement__ = 129;
      sumnt2 = 0;
      current_statement__ = 132;
      for (int i = 1; i <= nots; ++i) {
        current_statement__ = 130;
        sumnt2 = (sumnt2 + (nts[(i - 1)] * nts[(i - 1)]));}
      current_statement__ = 133;
      validate_non_negative_index("beta", "p", p);
      current_statement__ = 134;
      z_miss_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 134;
      z_miss_1dim__ = (missing ? ntmiss : 0);
      current_statement__ = 134;
      validate_non_negative_index("z_miss", "missing ? ntmiss : 0",
                                  z_miss_1dim__);
      current_statement__ = 135;
      validate_non_negative_index("xbmodel", "n", n);
      current_statement__ = 136;
      validate_non_negative_index("bigS", "sumnt2", sumnt2);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += p;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += z_miss_1dim__;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_ind_gpp_marginal_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(p);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta = in__.vector(p);
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 2;
      phi = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        phi = stan::math::lb_constrain(phi, 0, lp__);
      } else {
        current_statement__ = 2;
        phi = stan::math::lb_constrain(phi, 0);
      }
      local_scalar_t__ sigma_sq;
      sigma_sq = DUMMY_VAR__;
      
      current_statement__ = 3;
      sigma_sq = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        sigma_sq = stan::math::lb_constrain(sigma_sq, 0, lp__);
      } else {
        current_statement__ = 3;
        sigma_sq = stan::math::lb_constrain(sigma_sq, 0);
      }
      std::vector<local_scalar_t__> z_miss;
      z_miss = std::vector<local_scalar_t__>(z_miss_1dim__, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(z_miss, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable z_miss");}
      local_scalar_t__ tau_sq;
      tau_sq = DUMMY_VAR__;
      
      current_statement__ = 5;
      tau_sq = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        tau_sq = stan::math::lb_constrain(tau_sq, 0, lp__);
      } else {
        current_statement__ = 5;
        tau_sq = stan::math::lb_constrain(tau_sq, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> xbmodel;
      xbmodel = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(xbmodel, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> bigS;
      bigS = std::vector<local_scalar_t__>(sumnt2, DUMMY_VAR__);
      
      {
        current_statement__ = 8;
        validate_non_negative_index("Sigma", "m2", m2);
        current_statement__ = 9;
        validate_non_negative_index("Sigma", "m2", m2);
        Eigen::Matrix<local_scalar_t__, -1, -1> Sigma;
        Sigma = Eigen::Matrix<local_scalar_t__, -1, -1>(m2, m2);
        stan::math::fill(Sigma, DUMMY_VAR__);
        
        current_statement__ = 11;
        validate_non_negative_index("Swinv", "m2", m2);
        current_statement__ = 12;
        validate_non_negative_index("Swinv", "m2", m2);
        Eigen::Matrix<local_scalar_t__, -1, -1> Swinv;
        Swinv = Eigen::Matrix<local_scalar_t__, -1, -1>(m2, m2);
        stan::math::fill(Swinv, DUMMY_VAR__);
        
        current_statement__ = 14;
        validate_non_negative_index("Cmat", "n", n);
        current_statement__ = 15;
        validate_non_negative_index("Cmat", "m2", m2);
        Eigen::Matrix<local_scalar_t__, -1, -1> Cmat;
        Cmat = Eigen::Matrix<local_scalar_t__, -1, -1>(n, m2);
        stan::math::fill(Cmat, DUMMY_VAR__);
        
        current_statement__ = 17;
        assign(xbmodel, nil_index_list(), multiply(X, beta),
          "assigning variable xbmodel");
        current_statement__ = 23;
        for (int i = 1; i <= (m2 - 1); ++i) {
          current_statement__ = 21;
          for (int j = (i + 1); j <= m2; ++j) {
            current_statement__ = 18;
            assign(Sigma,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::exp(
                ((-1 * phi) *
                  rvalue(dmat,
                    cons_list(index_uni(i),
                      cons_list(index_uni(j), nil_index_list())), "dmat"))),
              "assigning variable Sigma");
            current_statement__ = 19;
            assign(Sigma,
              cons_list(index_uni(j),
                cons_list(index_uni(i), nil_index_list())),
              rvalue(Sigma,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())), "Sigma"),
              "assigning variable Sigma");}}
        current_statement__ = 25;
        for (int i = 1; i <= m2; ++i) {
          current_statement__ = 24;
          assign(Sigma,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())), 1.0,
            "assigning variable Sigma");}
        current_statement__ = 26;
        assign(Swinv, nil_index_list(), inverse_spd(Sigma),
          "assigning variable Swinv");
        current_statement__ = 31;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 29;
          for (int j = 1; j <= m2; ++j) {
            current_statement__ = 27;
            assign(Cmat,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::exp(
                ((-1 * phi) *
                  rvalue(Cdist,
                    cons_list(index_uni(i),
                      cons_list(index_uni(j), nil_index_list())), "Cdist"))),
              "assigning variable Cmat");}}
        {
          int m;
          m = std::numeric_limits<int>::min();
          
          current_statement__ = 32;
          m = 1;
          current_statement__ = 51;
          for (int i = 1; i <= nots; ++i) {
            current_statement__ = 33;
            validate_non_negative_index("St", "nts[i]", nts[(i - 1)]);
            current_statement__ = 34;
            validate_non_negative_index("St", "nts[i]", nts[(i - 1)]);
            Eigen::Matrix<local_scalar_t__, -1, -1> St;
            St = Eigen::Matrix<local_scalar_t__, -1, -1>(nts[(i - 1)], nts[
              (i - 1)]);
            stan::math::fill(St, DUMMY_VAR__);
            
            current_statement__ = 36;
            validate_non_negative_index("Ct", "nts[i]", nts[(i - 1)]);
            current_statement__ = 37;
            validate_non_negative_index("Ct", "m2", m2);
            Eigen::Matrix<local_scalar_t__, -1, -1> Ct;
            Ct = Eigen::Matrix<local_scalar_t__, -1, -1>(nts[(i - 1)], m2);
            stan::math::fill(Ct, DUMMY_VAR__);
            
            current_statement__ = 39;
            assign(Ct, nil_index_list(),
              rvalue(Cmat,
                cons_list(
                  index_min_max(start_row[(i - 1)], fin_row[(i - 1)]),
                  cons_list(index_omni(), nil_index_list())), "Cmat"),
              "assigning variable Ct");
            current_statement__ = 40;
            assign(St, nil_index_list(),
              multiply(multiply(multiply(sigma_sq, Ct), Swinv),
                transpose(Ct)), "assigning variable St");
            current_statement__ = 43;
            for (int j = 1; j <= nts[(i - 1)]; ++j) {
              current_statement__ = 41;
              assign(St,
                cons_list(index_uni(j),
                  cons_list(index_uni(j), nil_index_list())),
                (rvalue(St,
                   cons_list(index_uni(j),
                     cons_list(index_uni(j), nil_index_list())), "St") +
                  tau_sq), "assigning variable St");}
            current_statement__ = 49;
            for (int k = 1; k <= nts[(i - 1)]; ++k) {
              current_statement__ = 47;
              for (int j = 1; j <= nts[(i - 1)]; ++j) {
                current_statement__ = 44;
                assign(bigS, cons_list(index_uni(m), nil_index_list()),
                  rvalue(St,
                    cons_list(index_uni(k),
                      cons_list(index_uni(j), nil_index_list())), "St"),
                  "assigning variable bigS");
                current_statement__ = 45;
                m = (m + 1);}}}
        }
      }
      {
        current_statement__ = 54;
        validate_non_negative_index("z1", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> z1;
        z1 = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(z1, DUMMY_VAR__);
        
        int m;
        m = std::numeric_limits<int>::min();
        
        current_statement__ = 56;
        m = 1;
        current_statement__ = 57;
        lp_accum__.add(
          inv_gamma_lpdf<propto__>(sigma_sq, sigma2_prior[(1 - 1)],
            sigma2_prior[(2 - 1)]));
        current_statement__ = 58;
        lp_accum__.add(
          inv_gamma_lpdf<propto__>(tau_sq, tau2_prior[(1 - 1)],
            tau2_prior[(2 - 1)]));
        current_statement__ = 60;
        if (logical_eq(phidist, 0)) {
          current_statement__ = 59;
          lp_accum__.add(
            uniform_lpdf<propto__>(phi, prior_phi_param[(1 - 1)],
              prior_phi_param[(2 - 1)]));
        } 
        current_statement__ = 62;
        if (logical_eq(phidist, 1)) {
          current_statement__ = 61;
          lp_accum__.add(
            gamma_lpdf<propto__>(phi, prior_phi_param[(1 - 1)],
              prior_phi_param[(2 - 1)]));
        } 
        current_statement__ = 64;
        if (logical_eq(phidist, 2)) {
          current_statement__ = 63;
          lp_accum__.add(
            cauchy_lpdf<propto__>(phi, prior_phi_param[(1 - 1)],
              prior_phi_param[(2 - 1)]));
        } 
        current_statement__ = 66;
        if (logical_gt(phidist, 2)) {
          current_statement__ = 65;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "Wrong prior distribution for phi; found phidist=";
          errmsg_stream__ << phidist;
          throw std::domain_error(errmsg_stream__.str());
        } 
        current_statement__ = 68;
        for (int i = 1; i <= ntobs; ++i) {
          current_statement__ = 67;
          assign(z1,
            cons_list(index_uni(data_obs_idx[(i - 1)]), nil_index_list()),
            yobs[(i - 1)], "assigning variable z1");}
        current_statement__ = 72;
        if (logical_gt(missing, 0)) {
          current_statement__ = 70;
          for (int k = 1; k <= ntmiss; ++k) {
            current_statement__ = 69;
            assign(z1,
              cons_list(index_uni(data_miss_idx[(k - 1)]), nil_index_list()),
              z_miss[(k - 1)], "assigning variable z1");}
        } 
        current_statement__ = 90;
        for (int i = 1; i <= nots; ++i) {
          current_statement__ = 73;
          validate_non_negative_index("zt", "nts[i]", nts[(i - 1)]);
          Eigen::Matrix<local_scalar_t__, -1, 1> zt;
          zt = Eigen::Matrix<local_scalar_t__, -1, 1>(nts[(i - 1)]);
          stan::math::fill(zt, DUMMY_VAR__);
          
          current_statement__ = 75;
          validate_non_negative_index("mut", "nts[i]", nts[(i - 1)]);
          Eigen::Matrix<local_scalar_t__, -1, 1> mut;
          mut = Eigen::Matrix<local_scalar_t__, -1, 1>(nts[(i - 1)]);
          stan::math::fill(mut, DUMMY_VAR__);
          
          current_statement__ = 77;
          validate_non_negative_index("St", "nts[i]", nts[(i - 1)]);
          current_statement__ = 78;
          validate_non_negative_index("St", "nts[i]", nts[(i - 1)]);
          Eigen::Matrix<local_scalar_t__, -1, -1> St;
          St = Eigen::Matrix<local_scalar_t__, -1, -1>(nts[(i - 1)], nts[
            (i - 1)]);
          stan::math::fill(St, DUMMY_VAR__);
          
          current_statement__ = 80;
          assign(zt, nil_index_list(),
            rvalue(z1,
              cons_list(index_min_max(start_row[(i - 1)], fin_row[(i - 1)]),
                nil_index_list()), "z1"), "assigning variable zt");
          current_statement__ = 81;
          assign(mut, nil_index_list(),
            rvalue(xbmodel,
              cons_list(index_min_max(start_row[(i - 1)], fin_row[(i - 1)]),
                nil_index_list()), "xbmodel"), "assigning variable mut");
          current_statement__ = 87;
          for (int k = 1; k <= nts[(i - 1)]; ++k) {
            current_statement__ = 85;
            for (int j = 1; j <= nts[(i - 1)]; ++j) {
              current_statement__ = 82;
              assign(St,
                cons_list(index_uni(k),
                  cons_list(index_uni(j), nil_index_list())), bigS[(m - 1)],
                "assigning variable St");
              current_statement__ = 83;
              m = (m + 1);}}
          current_statement__ = 88;
          lp_accum__.add(multi_normal_lpdf<propto__>(zt, mut, St));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_ind_gpp_marginal_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(p);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta = in__.vector(p);
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      phi = in__.scalar();
      current_statement__ = 2;
      phi = stan::math::lb_constrain(phi, 0);
      double sigma_sq;
      sigma_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_sq = in__.scalar();
      current_statement__ = 3;
      sigma_sq = stan::math::lb_constrain(sigma_sq, 0);
      std::vector<double> z_miss;
      z_miss = std::vector<double>(z_miss_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(z_miss, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable z_miss");}
      double tau_sq;
      tau_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      tau_sq = in__.scalar();
      current_statement__ = 5;
      tau_sq = stan::math::lb_constrain(tau_sq, 0);
      Eigen::Matrix<double, -1, 1> xbmodel;
      xbmodel = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(xbmodel, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> bigS;
      bigS = std::vector<double>(sumnt2, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(phi);
      vars__.emplace_back(sigma_sq);
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        vars__.emplace_back(z_miss[(sym1__ - 1)]);}
      vars__.emplace_back(tau_sq);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      {
        current_statement__ = 8;
        validate_non_negative_index("Sigma", "m2", m2);
        current_statement__ = 9;
        validate_non_negative_index("Sigma", "m2", m2);
        Eigen::Matrix<double, -1, -1> Sigma;
        Sigma = Eigen::Matrix<double, -1, -1>(m2, m2);
        stan::math::fill(Sigma, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 11;
        validate_non_negative_index("Swinv", "m2", m2);
        current_statement__ = 12;
        validate_non_negative_index("Swinv", "m2", m2);
        Eigen::Matrix<double, -1, -1> Swinv;
        Swinv = Eigen::Matrix<double, -1, -1>(m2, m2);
        stan::math::fill(Swinv, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 14;
        validate_non_negative_index("Cmat", "n", n);
        current_statement__ = 15;
        validate_non_negative_index("Cmat", "m2", m2);
        Eigen::Matrix<double, -1, -1> Cmat;
        Cmat = Eigen::Matrix<double, -1, -1>(n, m2);
        stan::math::fill(Cmat, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 17;
        assign(xbmodel, nil_index_list(), multiply(X, beta),
          "assigning variable xbmodel");
        current_statement__ = 23;
        for (int i = 1; i <= (m2 - 1); ++i) {
          current_statement__ = 21;
          for (int j = (i + 1); j <= m2; ++j) {
            current_statement__ = 18;
            assign(Sigma,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::exp(
                ((-1 * phi) *
                  rvalue(dmat,
                    cons_list(index_uni(i),
                      cons_list(index_uni(j), nil_index_list())), "dmat"))),
              "assigning variable Sigma");
            current_statement__ = 19;
            assign(Sigma,
              cons_list(index_uni(j),
                cons_list(index_uni(i), nil_index_list())),
              rvalue(Sigma,
                cons_list(index_uni(i),
                  cons_list(index_uni(j), nil_index_list())), "Sigma"),
              "assigning variable Sigma");}}
        current_statement__ = 25;
        for (int i = 1; i <= m2; ++i) {
          current_statement__ = 24;
          assign(Sigma,
            cons_list(index_uni(i),
              cons_list(index_uni(i), nil_index_list())), 1.0,
            "assigning variable Sigma");}
        current_statement__ = 26;
        assign(Swinv, nil_index_list(), inverse_spd(Sigma),
          "assigning variable Swinv");
        current_statement__ = 31;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 29;
          for (int j = 1; j <= m2; ++j) {
            current_statement__ = 27;
            assign(Cmat,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::exp(
                ((-1 * phi) *
                  rvalue(Cdist,
                    cons_list(index_uni(i),
                      cons_list(index_uni(j), nil_index_list())), "Cdist"))),
              "assigning variable Cmat");}}
        {
          int m;
          m = std::numeric_limits<int>::min();
          
          current_statement__ = 32;
          m = 1;
          current_statement__ = 51;
          for (int i = 1; i <= nots; ++i) {
            current_statement__ = 33;
            validate_non_negative_index("St", "nts[i]", nts[(i - 1)]);
            current_statement__ = 34;
            validate_non_negative_index("St", "nts[i]", nts[(i - 1)]);
            Eigen::Matrix<double, -1, -1> St;
            St = Eigen::Matrix<double, -1, -1>(nts[(i - 1)], nts[(i - 1)]);
            stan::math::fill(St, std::numeric_limits<double>::quiet_NaN());
            
            current_statement__ = 36;
            validate_non_negative_index("Ct", "nts[i]", nts[(i - 1)]);
            current_statement__ = 37;
            validate_non_negative_index("Ct", "m2", m2);
            Eigen::Matrix<double, -1, -1> Ct;
            Ct = Eigen::Matrix<double, -1, -1>(nts[(i - 1)], m2);
            stan::math::fill(Ct, std::numeric_limits<double>::quiet_NaN());
            
            current_statement__ = 39;
            assign(Ct, nil_index_list(),
              rvalue(Cmat,
                cons_list(
                  index_min_max(start_row[(i - 1)], fin_row[(i - 1)]),
                  cons_list(index_omni(), nil_index_list())), "Cmat"),
              "assigning variable Ct");
            current_statement__ = 40;
            assign(St, nil_index_list(),
              multiply(multiply(multiply(sigma_sq, Ct), Swinv),
                transpose(Ct)), "assigning variable St");
            current_statement__ = 43;
            for (int j = 1; j <= nts[(i - 1)]; ++j) {
              current_statement__ = 41;
              assign(St,
                cons_list(index_uni(j),
                  cons_list(index_uni(j), nil_index_list())),
                (rvalue(St,
                   cons_list(index_uni(j),
                     cons_list(index_uni(j), nil_index_list())), "St") +
                  tau_sq), "assigning variable St");}
            current_statement__ = 49;
            for (int k = 1; k <= nts[(i - 1)]; ++k) {
              current_statement__ = 47;
              for (int j = 1; j <= nts[(i - 1)]; ++j) {
                current_statement__ = 44;
                assign(bigS, cons_list(index_uni(m), nil_index_list()),
                  rvalue(St,
                    cons_list(index_uni(k),
                      cons_list(index_uni(j), nil_index_list())), "St"),
                  "assigning variable bigS");
                current_statement__ = 45;
                m = (m + 1);}}}
        }
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(xbmodel[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= sumnt2; ++sym1__) {
          vars__.emplace_back(bigS[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(p);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 1;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      phi = context__.vals_r("phi")[(1 - 1)];
      double phi_free__;
      phi_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      phi_free__ = stan::math::lb_free(phi, 0);
      double sigma_sq;
      sigma_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_sq = context__.vals_r("sigma_sq")[(1 - 1)];
      double sigma_sq_free__;
      sigma_sq_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_sq_free__ = stan::math::lb_free(sigma_sq, 0);
      std::vector<double> z_miss;
      z_miss = std::vector<double>(z_miss_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(z_miss, nil_index_list(), context__.vals_r("z_miss"),
        "assigning variable z_miss");
      double tau_sq;
      tau_sq = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      tau_sq = context__.vals_r("tau_sq")[(1 - 1)];
      double tau_sq_free__;
      tau_sq_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      tau_sq_free__ = stan::math::lb_free(tau_sq, 0);
      for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(phi_free__);
      vars__.emplace_back(sigma_sq_free__);
      for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
        vars__.emplace_back(z_miss[(sym1__ - 1)]);}
      vars__.emplace_back(tau_sq_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta");
    names__.emplace_back("phi");
    names__.emplace_back("sigma_sq");
    names__.emplace_back("z_miss");
    names__.emplace_back("tau_sq");
    names__.emplace_back("xbmodel");
    names__.emplace_back("bigS");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(p)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(z_miss_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(sumnt2)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma_sq");
    for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "z_miss" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "tau_sq");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "xbmodel" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= sumnt2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "bigS" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "sigma_sq");
    for (int sym1__ = 1; sym1__ <= z_miss_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "z_miss" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "tau_sq");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "xbmodel" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= sumnt2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "bigS" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << p << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z_miss\",\"type\":{\"name\":\"array\",\"length\":" << z_miss_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"xbmodel\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"bigS\",\"type\":{\"name\":\"array\",\"length\":" << sumnt2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << p << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"z_miss\",\"type\":{\"name\":\"array\",\"length\":" << z_miss_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"tau_sq\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"xbmodel\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"bigS\",\"type\":{\"name\":\"array\",\"length\":" << sumnt2 << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_ind_gpp_marginal_namespace::model_ind_gpp_marginal;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_ind_gpp_marginal_namespace::profiles__;
}
#endif
#endif
