% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_request.R
\name{span_request_queries}
\alias{span_request_queries}
\title{Generate multiple queries that don't exceed a year limit}
\usage{
span_request_queries(start_year, end_year, year_limit, query_fn)
}
\arguments{
\item{start_year}{numeric}

\item{end_year}{numeric}

\item{year_limit}{numeric}

\item{query_fn}{a function or closure that takes two arguments, \code{start_year}
and \code{end_year}, and returns a query (see \code{\link[purrr:partial]{purrr::partial()}})}
}
\value{
a list of query objects in reverse chronological order
}
\description{
Generate multiple queries that don't exceed a year limit
}
\seealso{
Other blsR-queries: 
\code{\link{query_all_surveys}()},
\code{\link{query_latest_observation}()},
\code{\link{query_n_series}()},
\code{\link{query_popular_series}()},
\code{\link{query_series}()},
\code{\link{query_survey_info}()}

Other blsR-utils: 
\code{\link{data_as_table}()},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_series_request}()},
\code{\link{tidy_periods}()},
\code{\link{tidy_table_as_zoo}()}
}
\concept{blsR-queries}
\concept{blsR-utils}
