% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series_table.R
\name{get_n_series_table}
\alias{get_n_series_table}
\title{Retrieve multiple time series in one API request and return a single tibble}
\usage{
get_n_series_table(
  series_ids,
  api_key,
  start_year = NA,
  end_year = NA,
  tidy = FALSE,
  parse_values = TRUE,
  ...
)
}
\arguments{
\item{series_ids}{a named list of BLS time-series IDs. If the
list items are named then the names will be used in the returned list}

\item{api_key}{a mandatory API key, available from
\url{https://data.bls.gov/registrationEngine/}}

\item{start_year}{optional numeric 4-digit year}

\item{end_year}{optional numeric 4-digit year}

\item{tidy}{optional boolean. Return will use \code{\link[=tidy_periods]{tidy_periods()}} if true}

\item{parse_values}{optional boolean. If set to \code{true} (default) it will
attempt to parse the values of requested data series and cast numeric strings
as numeric values. If set to \code{false} it will retain them as strings.}

\item{...}{additional parameters to pass to \code{\link{get_series_tables}}}
}
\value{
a tibble of multiple merged time series
}
\description{
Retrieve multiple time series in one API request and return a single tibble
}
\examples{
\dontrun{
get_n_series_table(
  list(uer.men ='LNS14000001', uer.women = 'LNS14000002'),
  'your-api-key-here',
  start_year = 2005, end_year=2006
)
}

}
\seealso{
Other blsR-requests: 
\code{\link{bls_request}()},
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series_table}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()}
}
\concept{blsR-requests}
