% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blsR.R
\docType{package}
\name{blsR}
\alias{blsR}
\title{blsR: Retrieve Data From the U.S. Bureau Of Labor Statistics API}
\description{
\code{blsR} provides functions for retrieving and processing data from the BLS API.
The functions are divided into 4 categories: query generators, query requests,
result processors, and the user-friendly simplified interface.
}
\section{API Key and Definition}{


The API key is an optional parameter, but it is recommended you register for
an API key and use it. Requests without a key are limited to 10 years of data
per request, 25 series per query, and 25 queries per day. You can register at:
\url{https://data.bls.gov/registrationEngine/}

This implementation was based on the signatures available at:
\url{https://www.bls.gov/developers/api_signature_v2.htm}

The B.L.S. Frequently asked questions is available at:
\url{https://www.bls.gov/developers/api_faqs.htm}
}

\section{General Workflow}{


This package was designed with a three-step workflow in mind:
\itemize{
\item Identify which data you would like to retrieve and create a query.
\item Make an http request to execute a query (\code{\link[=bls_request]{bls_request()}})
\item Modify the response data to fit the user workflow
}

You can customize this workflow by creating your own query objects which
consist of a target URL and an optional payload as documented in the API Spec.
You may also want to create a custom results processor to shape the data to
suit individual needs and wrap those into a single call like
\code{\link[=get_series_table]{get_series_table()}} does.
}

\section{Query Generators}{


The query generators return a list suitable for passing to \code{\link[=bls_request]{bls_request()}}.
Most users should never need to access these functions directly but they are
made available for advanced users and user-extensions.
\itemize{
\item \code{\link[=query_series]{query_series()}} - Create a query for a single time series
\item \code{\link[=query_n_series]{query_n_series()}} - Create a query to retrieve one or more time series
and their catalog data
\item \code{\link[=query_popular_series]{query_popular_series()}} - Create a query to retrieve popular series
\item \code{\link[=query_all_surveys]{query_all_surveys()}} - Create a query to retrieve all surveys
\item \code{\link[=query_survey_info]{query_survey_info()}} - Create a query to retrieve information about a
survey
\item \code{\link[=query_latest_observation]{query_latest_observation()}} - Create a Query to retrieve the latest
observation for a time series
}
}

\section{Query Requests}{


The query-requester functions will execute the query by making the API request
and returning a minimally-processed response. These are likely to be the
most suitable functions to use for users who want to access the raw results.
\itemize{
\item \code{\link[=bls_request]{bls_request()}} - Execute a query and return the unprocessed results
\item \code{\link[=get_series]{get_series()}} - Create and execute query for a single time series
\item \code{\link[=get_n_series]{get_n_series()}} - Create and execute a query to retrieve one or more
time series and their catalog data
\item \code{\link[=get_popular_series]{get_popular_series()}} - Create and execute a query to retrieve popular
series
\item \code{\link[=get_all_surveys]{get_all_surveys()}} - Create and execute a query to retrieve all surveys
\item \code{\link[=get_survey_info]{get_survey_info()}} - Create and execute a query to retrieve information
about a survey
\item \code{\link[=get_latest_observation]{get_latest_observation()}} - Create and execute a query to retrieve the
latest observation for a time series
}
}

\section{Result Processors}{


The result-processor functions will transform the raw API response data
structures into data structures more likely to be suitable for modern user
workflows. The functions generally take as input the values returned by the
query-requester functions and make transform the data to different formats
or modify the output of another result-processor function.
\itemize{
\item \code{\link[=data_as_table]{data_as_table()}} - Flatten the data list into a table
\item \code{\link[=merge_tables]{merge_tables()}} - Merge multiple tables by period
\item \code{\link[=tidy_periods]{tidy_periods()}} - Transform periods to a more useful format
\item \code{\link[=data_as_tidy_table]{data_as_tidy_table()}} - Flatten the data list and transform period data
\item \code{\link[=merge_tidy_tables]{merge_tidy_tables()}} - Merge multiple tables with tidy period data
}
}

\section{Simplified Interface}{


These functions simplify the query generation, execution, and response
processing into a single function call, including extended request periods
that have to be broken down into multiple API requests. For most common use
cases these are likely to be the only functions needed.
\itemize{
\item \code{\link[=get_series_table]{get_series_table()}} - Request one series and return a data table
\item \code{\link[=get_series_tables]{get_series_tables()}} - Request series and return list of data tables
\item \code{\link[=get_n_series_table]{get_n_series_table()}} - Request series and return one table of values
}
}

