% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{blocks}
\alias{blocks}
\title{Block designs for unstructured treatment sets}
\usage{
blocks(
  treatments,
  replicates,
  blocks = NULL,
  searches = NULL,
  seed = NULL,
  jumps = 1
)
}
\arguments{
\item{treatments}{the total required number of treatments partitioned into equally replicated treatment sets.}

\item{replicates}{the replication numbers of the equally replicated treatment sets.}

\item{blocks}{the number of nested blocks in each level of nesting from the top level down.}

\item{searches}{the maximum number of local optima searched for a design optimization.}

\item{seed}{an integer initializing the random number generator.}

\item{jumps}{the number of pairwise random treatment swaps used to escape a local maxima.}
}
\value{
\item{Replication}{A table showing the replication number of each treatment in the design.}
\item{Design}{Data frame giving the optimized block and treatment design in plot order.}
\item{Plan}{Data frame showing a plan view of the treatment design in the bottom level of the design.}
\item{Blocks_model}{The D-efficiencies and the A-efficiencies of the blocks in each nested level of the 
 design together with A-efficiency upper-bounds, where available.}
\item{seed}{Numerical seed used for random number generator.}
\item{searches}{Maximum number of searches used for each level.}
\item{jumps}{Number of random treatment swaps used to escape a local maxima.}
}
\description{
Constructs randomized multi-level nested block designs for unstructured treatment sets.
}
\details{
Constructs randomized multi-level nested block designs for any arbitrary
number of unstructured treatments and any arbitrary feasible depth of nesting.

\code{treatments} is a partition of the number of treatments into equi-replicate treatment sets.

\code{replicates} is a set of replication numbers for the equi-replicate treatment sets.

\code{blocks} are the nested blocks levels in decreasing order of block size where
each level defines the number of blocks nested within the blocks of the preceding level.
The top-level block is assumed to be single super-block containing a full set of plots. 
The algorithm finds block sizes automatically for each level of nesting and the block sizes within
each level of nesting will never differ by more than a single plot.

Unreplicated treatments are allowed and any simple nested block design can be augmented by any number 
of unreplicated treatments using the \code{treatments} and \code{replicates} formula. 
However, it may be preferable to find an efficient blocked design
for the replicated treatment sets and then to add the unreplicated treatments heuristically. 

The \code{blocks} function constructs all block designs algorithmically except for certain special block designs
for r replicates of \code{v x v} treatments or r-1 replicates of \code{v x (v-1)} treatments in blocks of size v.
Provided that a set of r-1 mutually orthogonal Latin squares of size \code{v x v} exists, these designs are
constructed algebraically and are guaranteed to achieve optimality. See \code{\link[blocksdesign]{squarelattice}} 
and \code{\link[blocksdesign]{rectlattice}} for information about which design sizes are constructed algebraically.
}
\examples{

## The number of searches in the following examples have been limited for fast execution.  
## In practice, the number of searches may need to be increased for optimum results.
## Designs should be rebuilt several times to check that a near-optimum design has been found.  

# Completely randomized design for 6 treatments with 2 replicates and 1 control with 4 replicates 
blocks(treatments=list(6,1),replicates=list(2,4))

# 12 treatments x 4 replicates in 4 complete blocks with 4 sub-blocks of size 3
# rectangular lattice see Plan 10.10 Cochran and Cox 1957.
\donttest{blocks(treatments=12,replicates=4,blocks=list(4,4))}

# 3 treatments x 2 replicates + 2 treatments x 4 replicates in two complete randomized blocks
blocks(treatments=list(3,2),replicates=list(2,4),blocks=2)

# 50 treatments x 4 replicates with 4 main blocks and 5 nested sub-blocks in each main block
blocks(treatments=50,replicates=4,blocks=list(4,5))

# as above but with 20 additional single replicate treatments, one single treatment per sub-block
\donttest{blocks(treatments=list(50,20),replicates=list(4,1),blocks=list(4,5))}

# 6 replicates of 6 treatments in 4 blocks of size 9 (non-binary block design)
blocks(treatments=6,replicates=6,blocks=4)

# 128 treatments x 2 replicates with two main blocks and 3 levels of nesting
 \donttest{blocks(128,2,list(2,2,2,2))}

# 64 treatments x 4 replicates with 4 main blocks, 8 nested sub-blocks of size 8
# (lattice), 16 nested sub-sub blocks of size 4 and 32 nested sub-sub-sub blocks of size 2
 \donttest{blocks(64,4,list(4,8,2,2))}

# 100 treatments x 4 replicates with 4 main blocks nested blocks of size 10 (lattice square)
blocks(100,4,list(4,10)) 

}
\references{
Cochran, W.G., and G.M. Cox. 1957. Experimental Designs, 2nd ed., Wiley, New York.
}
