% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarringtonManning.R
\name{n_fix,FarringtonManning-method}
\alias{n_fix,FarringtonManning-method}
\title{Fixed Sample Size}
\usage{
\S4method{n_fix}{FarringtonManning}(design, nuisance, rounded = TRUE, ...)
}
\arguments{
\item{design}{Object of class \code{FarringtonManning} created
by \code{setupFarringtonManning}.}

\item{nuisance}{Value of the nuisance parameter. For the
Farrington-Manning test this is the overall response rate.}

\item{rounded}{Whether the calculated sample size should be rounded up such that
the allocation ratio is preserved.}

\item{...}{Further optional arguments.}
}
\value{
One value of the fixed sample size for every nuisance parameter
 and every value of n1.
}
\description{
Returns the sample size of a fixed design without sample size recalculation.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
d <- setupFarringtonManning(alpha = 0.025, beta = 0.2, r = 1, delta = 0, delta_NI = 0.25)
n_fix(d, nuisance = 0.3)

}
