% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_statistics.R
\docType{class}
\name{FarringtonManning-class}
\alias{FarringtonManning-class}
\alias{FarringtonManning}
\alias{setupFarringtonManning}
\title{Farrington Manning test}
\usage{
setupFarringtonManning(alpha, beta, r = 1, delta, delta_NI, n_max = Inf, ...)
}
\arguments{
\item{alpha}{One-sided type I error rate.}

\item{beta}{Type II error rate.}

\item{r}{Allocation ratio between experimental and control group.}

\item{delta}{Difference of effect size between alternative and null hypothesis.}

\item{delta_NI}{Non-inferiority margin.}

\item{n_max}{Maximal overall sample size. If the recalculated sample size
is greater than \code{n_max} it is set to \code{n_max}.}

\item{...}{Further optional arguments.}
}
\value{
An object of class \code{\link{FarringtonManning}}.
}
\description{
This class implements a Farrington-Manning test for non-inferiority
trials. A trial with binary outcomes in two groups \code{T} and
\code{C} is assumed.

The function \code{\link{setupFarringtonManning}} creates an object of
\code{\link{FarringtonManning}}.
}
\details{
The following methods are available for this class:
\code{\link{toer}}, \code{\link{pow}}, \code{\link{n_dist}},
\code{\link{adjusted_alpha}}, and \code{\link{n_fix}}.
Check the design specific documentation for details.
}
\examples{
design <- setupFarringtonManning(alpha = .025, beta = .2, r = 1, delta = 0,
delta_NI = .15)

}
