% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_credentials.R
\name{create_smtp_creds_key}
\alias{create_smtp_creds_key}
\title{Store SMTP credentials in the system's key-value store}
\usage{
create_smtp_creds_key(id, user = NULL, provider = NULL, host = NULL,
  port = NULL, use_ssl = NULL)
}
\arguments{
\item{id}{An identifying label for the keyname. The full key name is
constructed in the following way: \code{blastula-v1-<id>}.}

\item{user}{The username for the email account. Typically, this is the email
address associated with the account.}

\item{provider}{An optional email provider shortname for autocompleting STMP
configuration details (the \code{host}, \code{port}, \code{use_ssl} options). Options
currently include \code{gmail}, \code{outlook}, and \code{office365}. If nothing is
provided then values for \code{host}, \code{port}, and \code{use_ssl} are expected.}

\item{host}{Configuration info for the SMTP server. The \code{host}
and \code{port} parameters are the address and port for the SMTP server;
\code{use_ssl} is an option as to whether to use SSL: supply a \code{TRUE} or \code{FALSE}
value.}

\item{port}{Configuration info for the SMTP server. The \code{host}
and \code{port} parameters are the address and port for the SMTP server;
\code{use_ssl} is an option as to whether to use SSL: supply a \code{TRUE} or \code{FALSE}
value.}

\item{use_ssl}{Configuration info for the SMTP server. The \code{host}
and \code{port} parameters are the address and port for the SMTP server;
\code{use_ssl} is an option as to whether to use SSL: supply a \code{TRUE} or \code{FALSE}
value.}
}
\description{
We can set SMTP access credentials in the system-wide key-value store for the
purpose of more easily sending email messages through \code{\link[=smtp_send]{smtp_send()}}. With
this key added, the credentials helper \code{\link[=creds_key]{creds_key()}} can be used in the
\code{credentials} argument of \code{\link[=smtp_send]{smtp_send()}}.
}
\details{
Support for setting keys through \code{create_smtp_creds_key()} is provided
through the \pkg{keyring} package. This function cannot be used without that
package first being available on the system. We can use
\code{install.packages("keyring")} to install
}
\examples{
# Store SMTP crendentials using the
# system's secure key-value store to
# make it much easier to send email
# out through Gmail with `smtp_send()`;
# provide the `id` of "gmail_creds"

# create_smtp_creds_key(
#   id = "gmail_creds",
#   provider = "gmail",
#   user = "user_name@gmail.com",
#   )

}
