% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda_funs.R
\name{as.mcmc.list.bkmrfit.list}
\alias{as.mcmc.list.bkmrfit.list}
\title{Convert multi-chain bkmrfit to mcmc.list for coda MCMC diagnostics}
\usage{
\method{as.mcmc}{list.bkmrfit.list}(x, ...)
}
\arguments{
\item{x}{object of type kmrfit.list (from bkmrhat package)}

\item{...}{arguments to \code{\link[bkmrhat]{as.mcmc.bkmrfit}}}
}
\value{
An \code{\link[coda]{mcmc.list}} object
}
\description{
Converts a \code{kmrfit.list} (from the bkmrhat package) into
an \code{\link[coda]{mcmc.list}} object from the \code{coda} package.The
\code{coda} package enables many different types of MCMC diagnostics,
including \code{\link[coda]{geweke.diag}}, \code{\link[coda]{traceplot}} and
\code{\link[coda]{effectiveSize}}. Posterior summarization is also available,
such as \code{\link[coda]{HPDinterval}} and \code{\link[coda]{summary.mcmc}}.
Using multiple chains is necessary for certain MCMC diagnostics, such as
\code{\link[coda]{gelman.diag}}, and \code{\link[coda]{gelman.plot}}.
}
\examples{
# following example from https://jenfb.github.io/bkmr/overview.html
 \donttest{
set.seed(111)
library(coda)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
set.seed(111)

future::plan(strategy = future::multisession, workers=2)
# run 2 parallel Markov chains (more usually better)
fitkm.list <- kmbayes_parallel(nchains=2, y = y, Z = Z, X = X, iter = 1000,
  verbose = FALSE, varsel = FALSE)
mcmcobj = as.mcmc.list(fitkm.list)
summary(mcmcobj)
# Gelman/Rubin diagnostics won't work on certain objects,
# like delta parameters (when using variable selection),
# so the rstan version of this will work better (does not give errors)
 try(gelman.diag(mcmcobj))
# lots of functions in the coda package to use
plot(mcmcobj)
# both of these will also fail with delta functions (when using variable selection)
try(gelman.plot(mcmcobj))
try(geweke.plot(mcmcobj))

closeAllConnections()
}
}
