% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisg.R
\name{get_census_race_counts}
\alias{get_census_race_counts}
\title{Gets Census race counts necessary for BISG.}
\usage{
get_census_race_counts(
  geography,
  state,
  county = NULL,
  year = 2010,
  cache = FALSE
)
}
\arguments{
\item{geography}{The geographic level at which to obtain Census data. If
obtaining data from the decennial Census, can be up to "block". If
obtaining data from the ACS, can only be up to "block group".}

\item{state}{The state from which to obtain Census data, as a string.}

\item{county}{The county(ies) from which to obtain Census data. If NULL,
data is obtained from all counties in the state.}

\item{year}{The year to obtain Census data from. If 2010, uses decennial
data. Otherwise, uses the 5-year ACS summary data.}

\item{cache}{A bool denoting whether the Census data should be cached.}
}
\value{
A tibble containing the race counts per geography unit for white,
 black, Hispanic/Latino, Asian, and other voters.
}
\description{
This function gets the columns necessary to run BISG in compliance with
the Census' Bureau's surname lists. It can extract columns for either the
decennial Census or the ACS.
}
